package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.ConfigurationSetName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateEventDestinationResponse(
    configurationSetArn: Optional[String] = Optional.Absent,
    configurationSetName: Optional[ConfigurationSetName] = Optional.Absent,
    eventDestination: Optional[
      zio.aws.pinpointsmsvoicev2.model.EventDestination
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateEventDestinationResponse = {
    import CreateEventDestinationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateEventDestinationResponse
      .builder()
      .optionallyWith(
        configurationSetArn.map(value => value: java.lang.String)
      )(_.configurationSetArn)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .optionallyWith(eventDestination.map(value => value.buildAwsValue()))(
        _.eventDestination
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationResponse
      .wrap(buildAwsValue())
}
object CreateEventDestinationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateEventDestinationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationResponse =
      zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationResponse(
        configurationSetArn.map(value => value),
        configurationSetName.map(value => value),
        eventDestination.map(value => value.asEditable)
      )
    def configurationSetArn: Optional[String]
    def configurationSetName: Optional[ConfigurationSetName]
    def eventDestination
        : Optional[zio.aws.pinpointsmsvoicev2.model.EventDestination.ReadOnly]
    def getConfigurationSetArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configurationSetArn", configurationSetArn)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
    def getEventDestination: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.EventDestination.ReadOnly
    ] = AwsError.unwrapOptionField("eventDestination", eventDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateEventDestinationResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationResponse.ReadOnly {
    override val configurationSetArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationSetArn())
      .map(value => value: String)
    override val configurationSetName: Optional[ConfigurationSetName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationSetName())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives
            .ConfigurationSetName(value)
        )
    override val eventDestination
        : Optional[zio.aws.pinpointsmsvoicev2.model.EventDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventDestination())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.EventDestination.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateEventDestinationResponse
  ): zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationResponse.ReadOnly =
    new Wrapper(impl)
}
