package zio.aws.pinpointsmsvoicev2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointsmsvoicev2.model.primitives.{Timestamp, OptOutListName}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CreateOptOutListResponse(
    optOutListArn: Optional[String] = Optional.Absent,
    optOutListName: Optional[OptOutListName] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.pinpointsmsvoicev2.model.Tag]] =
      Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateOptOutListResponse = {
    import CreateOptOutListResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateOptOutListResponse
      .builder()
      .optionallyWith(optOutListArn.map(value => value: java.lang.String))(
        _.optOutListArn
      )
      .optionallyWith(
        optOutListName.map(value =>
          OptOutListName.unwrap(value): java.lang.String
        )
      )(_.optOutListName)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.CreateOptOutListResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.CreateOptOutListResponse
      .wrap(buildAwsValue())
}
object CreateOptOutListResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateOptOutListResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.CreateOptOutListResponse =
      zio.aws.pinpointsmsvoicev2.model.CreateOptOutListResponse(
        optOutListArn.map(value => value),
        optOutListName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdTimestamp.map(value => value)
      )
    def optOutListArn: Optional[String]
    def optOutListName: Optional[OptOutListName]
    def tags: Optional[List[zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly]]
    def createdTimestamp: Optional[Timestamp]
    def getOptOutListArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optOutListArn", optOutListArn)
    def getOptOutListName: ZIO[Any, AwsError, OptOutListName] =
      AwsError.unwrapOptionField("optOutListName", optOutListName)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateOptOutListResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.CreateOptOutListResponse.ReadOnly {
    override val optOutListArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optOutListArn())
      .map(value => value: String)
    override val optOutListName: Optional[OptOutListName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optOutListName())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.OptOutListName(value)
        )
    override val tags
        : Optional[List[zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointsmsvoicev2.model.Tag.wrap(item)
          }.toList
        )
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.Timestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateOptOutListResponse
  ): zio.aws.pinpointsmsvoicev2.model.CreateOptOutListResponse.ReadOnly =
    new Wrapper(impl)
}
