package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.ConfigurationSetName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteDefaultMessageTypeResponse(
    configurationSetArn: Optional[String] = Optional.Absent,
    configurationSetName: Optional[ConfigurationSetName] = Optional.Absent,
    messageType: Optional[zio.aws.pinpointsmsvoicev2.model.MessageType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse = {
    import DeleteDefaultMessageTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse
      .builder()
      .optionallyWith(
        configurationSetArn.map(value => value: java.lang.String)
      )(_.configurationSetArn)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .optionallyWith(messageType.map(value => value.unwrap))(_.messageType)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse
      .wrap(buildAwsValue())
}
object DeleteDefaultMessageTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse =
      zio.aws.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse(
        configurationSetArn.map(value => value),
        configurationSetName.map(value => value),
        messageType.map(value => value)
      )
    def configurationSetArn: Optional[String]
    def configurationSetName: Optional[ConfigurationSetName]
    def messageType: Optional[zio.aws.pinpointsmsvoicev2.model.MessageType]
    def getConfigurationSetArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configurationSetArn", configurationSetArn)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
    def getMessageType
        : ZIO[Any, AwsError, zio.aws.pinpointsmsvoicev2.model.MessageType] =
      AwsError.unwrapOptionField("messageType", messageType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse.ReadOnly {
    override val configurationSetArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationSetArn())
      .map(value => value: String)
    override val configurationSetName: Optional[ConfigurationSetName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationSetName())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives
            .ConfigurationSetName(value)
        )
    override val messageType
        : Optional[zio.aws.pinpointsmsvoicev2.model.MessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageType())
        .map(value => zio.aws.pinpointsmsvoicev2.model.MessageType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse
  ): zio.aws.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse.ReadOnly =
    new Wrapper(impl)
}
