package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  EventDestinationName,
  ConfigurationSetNameOrArn
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteEventDestinationRequest(
    configurationSetName: ConfigurationSetNameOrArn,
    eventDestinationName: EventDestinationName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteEventDestinationRequest = {
    import DeleteEventDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteEventDestinationRequest
      .builder()
      .configurationSetName(
        ConfigurationSetNameOrArn.unwrap(configurationSetName): java.lang.String
      )
      .eventDestinationName(
        EventDestinationName.unwrap(eventDestinationName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DeleteEventDestinationRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DeleteEventDestinationRequest
      .wrap(buildAwsValue())
}
object DeleteEventDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteEventDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.DeleteEventDestinationRequest =
      zio.aws.pinpointsmsvoicev2.model.DeleteEventDestinationRequest(
        configurationSetName,
        eventDestinationName
      )
    def configurationSetName: ConfigurationSetNameOrArn
    def eventDestinationName: EventDestinationName
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetNameOrArn] =
      ZIO.succeed(configurationSetName)
    def getEventDestinationName: ZIO[Any, Nothing, EventDestinationName] =
      ZIO.succeed(eventDestinationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteEventDestinationRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.DeleteEventDestinationRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetNameOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .ConfigurationSetNameOrArn(impl.configurationSetName())
    override val eventDestinationName: EventDestinationName =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .EventDestinationName(impl.eventDestinationName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteEventDestinationRequest
  ): zio.aws.pinpointsmsvoicev2.model.DeleteEventDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
