package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.PoolIdOrArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeletePoolRequest(poolId: PoolIdOrArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeletePoolRequest = {
    import DeletePoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeletePoolRequest
      .builder()
      .poolId(PoolIdOrArn.unwrap(poolId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpointsmsvoicev2.model.DeletePoolRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DeletePoolRequest.wrap(buildAwsValue())
}
object DeletePoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeletePoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.DeletePoolRequest =
      zio.aws.pinpointsmsvoicev2.model.DeletePoolRequest(poolId)
    def poolId: PoolIdOrArn
    def getPoolId: ZIO[Any, Nothing, PoolIdOrArn] = ZIO.succeed(poolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeletePoolRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.DeletePoolRequest.ReadOnly {
    override val poolId: PoolIdOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives.PoolIdOrArn(impl.poolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeletePoolRequest
  ): zio.aws.pinpointsmsvoicev2.model.DeletePoolRequest.ReadOnly = new Wrapper(
    impl
  )
}
