package zio.aws.pinpointsmsvoicev2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  Timestamp,
  OptOutListName,
  TwoWayChannelArn,
  PrimitiveBoolean
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DeletePoolResponse(
    poolArn: Optional[String] = Optional.Absent,
    poolId: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.pinpointsmsvoicev2.model.PoolStatus] =
      Optional.Absent,
    messageType: Optional[zio.aws.pinpointsmsvoicev2.model.MessageType] =
      Optional.Absent,
    twoWayEnabled: Optional[PrimitiveBoolean] = Optional.Absent,
    twoWayChannelArn: Optional[TwoWayChannelArn] = Optional.Absent,
    selfManagedOptOutsEnabled: Optional[PrimitiveBoolean] = Optional.Absent,
    optOutListName: Optional[OptOutListName] = Optional.Absent,
    sharedRoutesEnabled: Optional[PrimitiveBoolean] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeletePoolResponse = {
    import DeletePoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeletePoolResponse
      .builder()
      .optionallyWith(poolArn.map(value => value: java.lang.String))(_.poolArn)
      .optionallyWith(poolId.map(value => value: java.lang.String))(_.poolId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(messageType.map(value => value.unwrap))(_.messageType)
      .optionallyWith(
        twoWayEnabled.map(value =>
          PrimitiveBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.twoWayEnabled)
      .optionallyWith(
        twoWayChannelArn.map(value =>
          TwoWayChannelArn.unwrap(value): java.lang.String
        )
      )(_.twoWayChannelArn)
      .optionallyWith(
        selfManagedOptOutsEnabled.map(value =>
          PrimitiveBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.selfManagedOptOutsEnabled)
      .optionallyWith(
        optOutListName.map(value =>
          OptOutListName.unwrap(value): java.lang.String
        )
      )(_.optOutListName)
      .optionallyWith(
        sharedRoutesEnabled.map(value =>
          PrimitiveBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.sharedRoutesEnabled)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.pinpointsmsvoicev2.model.DeletePoolResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DeletePoolResponse.wrap(buildAwsValue())
}
object DeletePoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeletePoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.DeletePoolResponse =
      zio.aws.pinpointsmsvoicev2.model.DeletePoolResponse(
        poolArn.map(value => value),
        poolId.map(value => value),
        status.map(value => value),
        messageType.map(value => value),
        twoWayEnabled.map(value => value),
        twoWayChannelArn.map(value => value),
        selfManagedOptOutsEnabled.map(value => value),
        optOutListName.map(value => value),
        sharedRoutesEnabled.map(value => value),
        createdTimestamp.map(value => value)
      )
    def poolArn: Optional[String]
    def poolId: Optional[String]
    def status: Optional[zio.aws.pinpointsmsvoicev2.model.PoolStatus]
    def messageType: Optional[zio.aws.pinpointsmsvoicev2.model.MessageType]
    def twoWayEnabled: Optional[PrimitiveBoolean]
    def twoWayChannelArn: Optional[TwoWayChannelArn]
    def selfManagedOptOutsEnabled: Optional[PrimitiveBoolean]
    def optOutListName: Optional[OptOutListName]
    def sharedRoutesEnabled: Optional[PrimitiveBoolean]
    def createdTimestamp: Optional[Timestamp]
    def getPoolArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("poolArn", poolArn)
    def getPoolId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("poolId", poolId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.pinpointsmsvoicev2.model.PoolStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMessageType
        : ZIO[Any, AwsError, zio.aws.pinpointsmsvoicev2.model.MessageType] =
      AwsError.unwrapOptionField("messageType", messageType)
    def getTwoWayEnabled: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField("twoWayEnabled", twoWayEnabled)
    def getTwoWayChannelArn: ZIO[Any, AwsError, TwoWayChannelArn] =
      AwsError.unwrapOptionField("twoWayChannelArn", twoWayChannelArn)
    def getSelfManagedOptOutsEnabled: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField(
        "selfManagedOptOutsEnabled",
        selfManagedOptOutsEnabled
      )
    def getOptOutListName: ZIO[Any, AwsError, OptOutListName] =
      AwsError.unwrapOptionField("optOutListName", optOutListName)
    def getSharedRoutesEnabled: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField("sharedRoutesEnabled", sharedRoutesEnabled)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeletePoolResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.DeletePoolResponse.ReadOnly {
    override val poolArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.poolArn())
      .map(value => value: String)
    override val poolId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.poolId())
      .map(value => value: String)
    override val status: Optional[zio.aws.pinpointsmsvoicev2.model.PoolStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.pinpointsmsvoicev2.model.PoolStatus.wrap(value))
    override val messageType
        : Optional[zio.aws.pinpointsmsvoicev2.model.MessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageType())
        .map(value => zio.aws.pinpointsmsvoicev2.model.MessageType.wrap(value))
    override val twoWayEnabled: Optional[PrimitiveBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.twoWayEnabled())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.PrimitiveBoolean(value)
        )
    override val twoWayChannelArn: Optional[TwoWayChannelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.twoWayChannelArn())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.TwoWayChannelArn(value)
        )
    override val selfManagedOptOutsEnabled: Optional[PrimitiveBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selfManagedOptOutsEnabled())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.PrimitiveBoolean(value)
        )
    override val optOutListName: Optional[OptOutListName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optOutListName())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.OptOutListName(value)
        )
    override val sharedRoutesEnabled: Optional[PrimitiveBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sharedRoutesEnabled())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.PrimitiveBoolean(value)
        )
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.Timestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeletePoolResponse
  ): zio.aws.pinpointsmsvoicev2.model.DeletePoolResponse.ReadOnly = new Wrapper(
    impl
  )
}
