package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeAccountAttributesResponse(
    accountAttributes: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.AccountAttribute]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse = {
    import DescribeAccountAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse
      .builder()
      .optionallyWith(
        accountAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountAttributes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse
      .wrap(buildAwsValue())
}
object DescribeAccountAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse =
      zio.aws.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse(
        accountAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def accountAttributes: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.AccountAttribute.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getAccountAttributes: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.AccountAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("accountAttributes", accountAttributes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse.ReadOnly {
    override val accountAttributes: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.AccountAttribute.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accountAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.AccountAttribute.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse
  ): zio.aws.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
