package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeAccountLimitsResponse(
    accountLimits: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.AccountLimit]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse = {
    import DescribeAccountLimitsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse
      .builder()
      .optionallyWith(
        accountLimits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountLimits)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse
      .wrap(buildAwsValue())
}
object DescribeAccountLimitsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse =
      zio.aws.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse(
        accountLimits.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def accountLimits
        : Optional[List[zio.aws.pinpointsmsvoicev2.model.AccountLimit.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getAccountLimits: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.AccountLimit.ReadOnly
    ]] = AwsError.unwrapOptionField("accountLimits", accountLimits)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse.ReadOnly {
    override val accountLimits: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.AccountLimit.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accountLimits())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.AccountLimit.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse
  ): zio.aws.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse.ReadOnly =
    new Wrapper(impl)
}
