package zio.aws.pinpointsmsvoicev2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  MaxResults,
  NextToken,
  ConfigurationSetNameOrArn
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeConfigurationSetsRequest(
    configurationSetNames: Optional[Iterable[ConfigurationSetNameOrArn]] =
      Optional.Absent,
    filters: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.ConfigurationSetFilter]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest = {
    import DescribeConfigurationSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest
      .builder()
      .optionallyWith(
        configurationSetNames.map(value =>
          value.map { item =>
            ConfigurationSetNameOrArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.configurationSetNames)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest
      .wrap(buildAwsValue())
}
object DescribeConfigurationSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest =
      zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest(
        configurationSetNames.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def configurationSetNames: Optional[List[ConfigurationSetNameOrArn]]
    def filters: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.ConfigurationSetFilter.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getConfigurationSetNames
        : ZIO[Any, AwsError, List[ConfigurationSetNameOrArn]] =
      AwsError.unwrapOptionField("configurationSetNames", configurationSetNames)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.ConfigurationSetFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest.ReadOnly {
    override val configurationSetNames
        : Optional[List[ConfigurationSetNameOrArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationSetNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.primitives
            .ConfigurationSetNameOrArn(item)
        }.toList
      )
    override val filters: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.ConfigurationSetFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.ConfigurationSetFilter.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.NextToken(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.MaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest
  ): zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest.ReadOnly =
    new Wrapper(impl)
}
