package zio.aws.pinpointsmsvoicev2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  MaxResults,
  NextToken,
  Keyword,
  PhoneOrPoolIdOrArn
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeKeywordsRequest(
    originationIdentity: PhoneOrPoolIdOrArn,
    keywords: Optional[Iterable[Keyword]] = Optional.Absent,
    filters: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.KeywordFilter]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest = {
    import DescribeKeywordsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest
      .builder()
      .originationIdentity(
        PhoneOrPoolIdOrArn.unwrap(originationIdentity): java.lang.String
      )
      .optionallyWith(
        keywords.map(value =>
          value.map { item =>
            Keyword.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.keywords)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsRequest
      .wrap(buildAwsValue())
}
object DescribeKeywordsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsRequest =
      zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsRequest(
        originationIdentity,
        keywords.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def originationIdentity: PhoneOrPoolIdOrArn
    def keywords: Optional[List[Keyword]]
    def filters: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.KeywordFilter.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getOriginationIdentity: ZIO[Any, Nothing, PhoneOrPoolIdOrArn] =
      ZIO.succeed(originationIdentity)
    def getKeywords: ZIO[Any, AwsError, List[Keyword]] =
      AwsError.unwrapOptionField("keywords", keywords)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.KeywordFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsRequest.ReadOnly {
    override val originationIdentity: PhoneOrPoolIdOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PhoneOrPoolIdOrArn(impl.originationIdentity())
    override val keywords: Optional[List[Keyword]] = zio.aws.core.internal
      .optionalFromNullable(impl.keywords())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.primitives.Keyword(item)
        }.toList
      )
    override val filters: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.KeywordFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.KeywordFilter.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.NextToken(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.MaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest
  ): zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsRequest.ReadOnly =
    new Wrapper(impl)
}
