package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeKeywordsResponse(
    originationIdentityArn: Optional[String] = Optional.Absent,
    originationIdentity: Optional[String] = Optional.Absent,
    keywords: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.KeywordInformation]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse = {
    import DescribeKeywordsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse
      .builder()
      .optionallyWith(
        originationIdentityArn.map(value => value: java.lang.String)
      )(_.originationIdentityArn)
      .optionallyWith(
        originationIdentity.map(value => value: java.lang.String)
      )(_.originationIdentity)
      .optionallyWith(
        keywords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keywords)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsResponse
      .wrap(buildAwsValue())
}
object DescribeKeywordsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsResponse =
      zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsResponse(
        originationIdentityArn.map(value => value),
        originationIdentity.map(value => value),
        keywords.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def originationIdentityArn: Optional[String]
    def originationIdentity: Optional[String]
    def keywords: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.KeywordInformation.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getOriginationIdentityArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("originationIdentityArn", originationIdentityArn)
    def getOriginationIdentity: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("originationIdentity", originationIdentity)
    def getKeywords: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.KeywordInformation.ReadOnly
    ]] = AwsError.unwrapOptionField("keywords", keywords)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsResponse.ReadOnly {
    override val originationIdentityArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originationIdentityArn())
        .map(value => value: String)
    override val originationIdentity: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.originationIdentity())
      .map(value => value: String)
    override val keywords: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.KeywordInformation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.keywords())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.KeywordInformation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse
  ): zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsResponse.ReadOnly =
    new Wrapper(impl)
}
