package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeOptOutListsResponse(
    optOutLists: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.OptOutListInformation]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsResponse = {
    import DescribeOptOutListsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsResponse
      .builder()
      .optionallyWith(
        optOutLists.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optOutLists)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DescribeOptOutListsResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DescribeOptOutListsResponse
      .wrap(buildAwsValue())
}
object DescribeOptOutListsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.DescribeOptOutListsResponse =
      zio.aws.pinpointsmsvoicev2.model.DescribeOptOutListsResponse(
        optOutLists.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def optOutLists: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.OptOutListInformation.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getOptOutLists: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.OptOutListInformation.ReadOnly
    ]] = AwsError.unwrapOptionField("optOutLists", optOutLists)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.DescribeOptOutListsResponse.ReadOnly {
    override val optOutLists: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.OptOutListInformation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.optOutLists())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.OptOutListInformation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsResponse
  ): zio.aws.pinpointsmsvoicev2.model.DescribeOptOutListsResponse.ReadOnly =
    new Wrapper(impl)
}
