package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{NextToken, OptOutListName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeOptedOutNumbersResponse(
    optOutListArn: Optional[String] = Optional.Absent,
    optOutListName: Optional[OptOutListName] = Optional.Absent,
    optedOutNumbers: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.OptedOutNumberInformation]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse = {
    import DescribeOptedOutNumbersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse
      .builder()
      .optionallyWith(optOutListArn.map(value => value: java.lang.String))(
        _.optOutListArn
      )
      .optionallyWith(
        optOutListName.map(value =>
          OptOutListName.unwrap(value): java.lang.String
        )
      )(_.optOutListName)
      .optionallyWith(
        optedOutNumbers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optedOutNumbers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse
      .wrap(buildAwsValue())
}
object DescribeOptedOutNumbersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse =
      zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse(
        optOutListArn.map(value => value),
        optOutListName.map(value => value),
        optedOutNumbers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def optOutListArn: Optional[String]
    def optOutListName: Optional[OptOutListName]
    def optedOutNumbers: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.OptedOutNumberInformation.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getOptOutListArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optOutListArn", optOutListArn)
    def getOptOutListName: ZIO[Any, AwsError, OptOutListName] =
      AwsError.unwrapOptionField("optOutListName", optOutListName)
    def getOptedOutNumbers: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.OptedOutNumberInformation.ReadOnly
    ]] = AwsError.unwrapOptionField("optedOutNumbers", optedOutNumbers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse.ReadOnly {
    override val optOutListArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optOutListArn())
      .map(value => value: String)
    override val optOutListName: Optional[OptOutListName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optOutListName())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.OptOutListName(value)
        )
    override val optedOutNumbers: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.OptedOutNumberInformation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.optedOutNumbers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.OptedOutNumberInformation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse
  ): zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse.ReadOnly =
    new Wrapper(impl)
}
