package zio.aws.pinpointsmsvoicev2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  MaxResults,
  NextToken,
  PoolIdOrArn
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribePoolsRequest(
    poolIds: Optional[Iterable[PoolIdOrArn]] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.pinpointsmsvoicev2.model.PoolFilter]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest = {
    import DescribePoolsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest
      .builder()
      .optionallyWith(
        poolIds.map(value =>
          value.map { item =>
            PoolIdOrArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.poolIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DescribePoolsRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DescribePoolsRequest.wrap(buildAwsValue())
}
object DescribePoolsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.DescribePoolsRequest =
      zio.aws.pinpointsmsvoicev2.model.DescribePoolsRequest(
        poolIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def poolIds: Optional[List[PoolIdOrArn]]
    def filters
        : Optional[List[zio.aws.pinpointsmsvoicev2.model.PoolFilter.ReadOnly]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getPoolIds: ZIO[Any, AwsError, List[PoolIdOrArn]] =
      AwsError.unwrapOptionField("poolIds", poolIds)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.PoolFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.DescribePoolsRequest.ReadOnly {
    override val poolIds: Optional[List[PoolIdOrArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.poolIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.primitives.PoolIdOrArn(item)
        }.toList
      )
    override val filters
        : Optional[List[zio.aws.pinpointsmsvoicev2.model.PoolFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointsmsvoicev2.model.PoolFilter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.NextToken(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.MaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest
  ): zio.aws.pinpointsmsvoicev2.model.DescribePoolsRequest.ReadOnly =
    new Wrapper(impl)
}
