package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeSenderIdsResponse(
    senderIds: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.SenderIdInformation]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsResponse = {
    import DescribeSenderIdsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsResponse
      .builder()
      .optionallyWith(
        senderIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.senderIds)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsResponse
      .wrap(buildAwsValue())
}
object DescribeSenderIdsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsResponse =
      zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsResponse(
        senderIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def senderIds: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.SenderIdInformation.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getSenderIds: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.SenderIdInformation.ReadOnly
    ]] = AwsError.unwrapOptionField("senderIds", senderIds)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsResponse.ReadOnly {
    override val senderIds: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.SenderIdInformation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.senderIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.SenderIdInformation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsResponse
  ): zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsResponse.ReadOnly =
    new Wrapper(impl)
}
