package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeSpendLimitsResponse(
    spendLimits: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.SpendLimit]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse = {
    import DescribeSpendLimitsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse
      .builder()
      .optionallyWith(
        spendLimits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.spendLimits)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse
      .wrap(buildAwsValue())
}
object DescribeSpendLimitsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse =
      zio.aws.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse(
        spendLimits.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def spendLimits
        : Optional[List[zio.aws.pinpointsmsvoicev2.model.SpendLimit.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getSpendLimits: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.SpendLimit.ReadOnly
    ]] = AwsError.unwrapOptionField("spendLimits", spendLimits)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse.ReadOnly {
    override val spendLimits
        : Optional[List[zio.aws.pinpointsmsvoicev2.model.SpendLimit.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spendLimits())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointsmsvoicev2.model.SpendLimit.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse
  ): zio.aws.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse.ReadOnly =
    new Wrapper(impl)
}
