package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.IsoCountryCode
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DisassociateOriginationIdentityResponse(
    poolArn: Optional[String] = Optional.Absent,
    poolId: Optional[String] = Optional.Absent,
    originationIdentityArn: Optional[String] = Optional.Absent,
    originationIdentity: Optional[String] = Optional.Absent,
    isoCountryCode: Optional[IsoCountryCode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse = {
    import DisassociateOriginationIdentityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse
      .builder()
      .optionallyWith(poolArn.map(value => value: java.lang.String))(_.poolArn)
      .optionallyWith(poolId.map(value => value: java.lang.String))(_.poolId)
      .optionallyWith(
        originationIdentityArn.map(value => value: java.lang.String)
      )(_.originationIdentityArn)
      .optionallyWith(
        originationIdentity.map(value => value: java.lang.String)
      )(_.originationIdentity)
      .optionallyWith(
        isoCountryCode.map(value =>
          IsoCountryCode.unwrap(value): java.lang.String
        )
      )(_.isoCountryCode)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse
      .wrap(buildAwsValue())
}
object DisassociateOriginationIdentityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse =
      zio.aws.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse(
        poolArn.map(value => value),
        poolId.map(value => value),
        originationIdentityArn.map(value => value),
        originationIdentity.map(value => value),
        isoCountryCode.map(value => value)
      )
    def poolArn: Optional[String]
    def poolId: Optional[String]
    def originationIdentityArn: Optional[String]
    def originationIdentity: Optional[String]
    def isoCountryCode: Optional[IsoCountryCode]
    def getPoolArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("poolArn", poolArn)
    def getPoolId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("poolId", poolId)
    def getOriginationIdentityArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("originationIdentityArn", originationIdentityArn)
    def getOriginationIdentity: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("originationIdentity", originationIdentity)
    def getIsoCountryCode: ZIO[Any, AwsError, IsoCountryCode] =
      AwsError.unwrapOptionField("isoCountryCode", isoCountryCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse.ReadOnly {
    override val poolArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.poolArn())
      .map(value => value: String)
    override val poolId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.poolId())
      .map(value => value: String)
    override val originationIdentityArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originationIdentityArn())
        .map(value => value: String)
    override val originationIdentity: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.originationIdentity())
      .map(value => value: String)
    override val isoCountryCode: Optional[IsoCountryCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isoCountryCode())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.IsoCountryCode(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse
  ): zio.aws.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse.ReadOnly =
    new Wrapper(impl)
}
