package zio.aws.pinpointsmsvoicev2.model
import scala.jdk.CollectionConverters.*
sealed trait KeywordAction {
  def unwrap
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordAction
}
object KeywordAction {
  def wrap(
      value: software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordAction
  ): zio.aws.pinpointsmsvoicev2.model.KeywordAction = value match {
    case software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordAction.AUTOMATIC_RESPONSE =>
      val r = AUTOMATIC_RESPONSE
      r
    case software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordAction.OPT_OUT =>
      val r = OPT_OUT
      r
    case software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordAction.OPT_IN =>
      val r = OPT_IN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.pinpointsmsvoicev2.model.KeywordAction {
    override def unwrap
        : software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordAction =
      software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordAction.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTOMATIC_RESPONSE
      extends zio.aws.pinpointsmsvoicev2.model.KeywordAction {
    override def unwrap
        : software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordAction =
      software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordAction.AUTOMATIC_RESPONSE
  }
  case object OPT_OUT extends zio.aws.pinpointsmsvoicev2.model.KeywordAction {
    override def unwrap
        : software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordAction =
      software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordAction.OPT_OUT
  }
  case object OPT_IN extends zio.aws.pinpointsmsvoicev2.model.KeywordAction {
    override def unwrap
        : software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordAction =
      software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordAction.OPT_IN
  }
}
