package zio.aws.pinpointsmsvoicev2.model
import scala.jdk.CollectionConverters.*
sealed trait KeywordFilterName {
  def unwrap: software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordFilterName
}
object KeywordFilterName {
  def wrap(
      value: software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordFilterName
  ): zio.aws.pinpointsmsvoicev2.model.KeywordFilterName = value match {
    case software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordFilterName.KEYWORD_ACTION =>
      val r = `keyword-action`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.pinpointsmsvoicev2.model.KeywordFilterName {
    override def unwrap
        : software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordFilterName =
      software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object `keyword-action`
      extends zio.aws.pinpointsmsvoicev2.model.KeywordFilterName {
    override def unwrap
        : software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordFilterName =
      software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordFilterName.KEYWORD_ACTION
  }
}
