package zio.aws.pinpointsmsvoicev2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  MaxResults,
  NextToken,
  PoolIdOrArn
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListPoolOriginationIdentitiesRequest(
    poolId: PoolIdOrArn,
    filters: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilter]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest = {
    import ListPoolOriginationIdentitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest
      .builder()
      .poolId(PoolIdOrArn.unwrap(poolId): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest
      .wrap(buildAwsValue())
}
object ListPoolOriginationIdentitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest =
      zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest(
        poolId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def poolId: PoolIdOrArn
    def filters: Optional[List[
      zio.aws.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilter.ReadOnly
    ]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getPoolId: ZIO[Any, Nothing, PoolIdOrArn] = ZIO.succeed(poolId)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest.ReadOnly {
    override val poolId: PoolIdOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives.PoolIdOrArn(impl.poolId())
    override val filters: Optional[List[
      zio.aws.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilter.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilter
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.NextToken(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.MaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest
  ): zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest.ReadOnly =
    new Wrapper(impl)
}
