package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.AmazonResourceName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    resourceArn: Optional[AmazonResourceName] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.pinpointsmsvoicev2.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        resourceArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.resourceArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.ListTagsForResourceResponse =
      zio.aws.pinpointsmsvoicev2.model.ListTagsForResourceResponse(
        resourceArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceArn: Optional[AmazonResourceName]
    def tags: Optional[List[zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly]]
    def getResourceArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListTagsForResourceResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.ListTagsForResourceResponse.ReadOnly {
    override val resourceArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceArn())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.AmazonResourceName(value)
        )
    override val tags
        : Optional[List[zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointsmsvoicev2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListTagsForResourceResponse
  ): zio.aws.pinpointsmsvoicev2.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
