package zio.aws.pinpointsmsvoicev2.model
import scala.jdk.CollectionConverters.*
sealed trait NumberType {
  def unwrap
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberType
}
object NumberType {
  def wrap(
      value: software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberType
  ): zio.aws.pinpointsmsvoicev2.model.NumberType = value match {
    case software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberType.SHORT_CODE =>
      val r = SHORT_CODE
      r
    case software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberType.LONG_CODE =>
      val r = LONG_CODE
      r
    case software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberType.TOLL_FREE =>
      val r = TOLL_FREE
      r
    case software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberType.TEN_DLC =>
      val r = TEN_DLC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.pinpointsmsvoicev2.model.NumberType {
    override def unwrap
        : software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberType =
      software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberType.UNKNOWN_TO_SDK_VERSION
  }
  case object SHORT_CODE extends zio.aws.pinpointsmsvoicev2.model.NumberType {
    override def unwrap
        : software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberType =
      software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberType.SHORT_CODE
  }
  case object LONG_CODE extends zio.aws.pinpointsmsvoicev2.model.NumberType {
    override def unwrap
        : software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberType =
      software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberType.LONG_CODE
  }
  case object TOLL_FREE extends zio.aws.pinpointsmsvoicev2.model.NumberType {
    override def unwrap
        : software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberType =
      software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberType.TOLL_FREE
  }
  case object TEN_DLC extends zio.aws.pinpointsmsvoicev2.model.NumberType {
    override def unwrap
        : software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberType =
      software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberType.TEN_DLC
  }
}
