package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{Timestamp, OptOutListName}
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class OptOutListInformation(
    optOutListArn: String,
    optOutListName: OptOutListName,
    createdTimestamp: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptOutListInformation = {
    import OptOutListInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptOutListInformation
      .builder()
      .optOutListArn(optOutListArn: java.lang.String)
      .optOutListName(OptOutListName.unwrap(optOutListName): java.lang.String)
      .createdTimestamp(Timestamp.unwrap(createdTimestamp): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.OptOutListInformation.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.OptOutListInformation.wrap(buildAwsValue())
}
object OptOutListInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptOutListInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.OptOutListInformation =
      zio.aws.pinpointsmsvoicev2.model
        .OptOutListInformation(optOutListArn, optOutListName, createdTimestamp)
    def optOutListArn: String
    def optOutListName: OptOutListName
    def createdTimestamp: Timestamp
    def getOptOutListArn: ZIO[Any, Nothing, String] = ZIO.succeed(optOutListArn)
    def getOptOutListName: ZIO[Any, Nothing, OptOutListName] =
      ZIO.succeed(optOutListName)
    def getCreatedTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(createdTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptOutListInformation
  ) extends zio.aws.pinpointsmsvoicev2.model.OptOutListInformation.ReadOnly {
    override val optOutListArn: String = impl.optOutListArn(): String
    override val optOutListName: OptOutListName =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .OptOutListName(impl.optOutListName())
    override val createdTimestamp: Timestamp =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .Timestamp(impl.createdTimestamp())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptOutListInformation
  ): zio.aws.pinpointsmsvoicev2.model.OptOutListInformation.ReadOnly =
    new Wrapper(impl)
}
