package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.FilterValue
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class OptedOutFilter(
    name: zio.aws.pinpointsmsvoicev2.model.OptedOutFilterName,
    values: Iterable[FilterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutFilter = {
    import OptedOutFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        FilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.pinpointsmsvoicev2.model.OptedOutFilter.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.OptedOutFilter.wrap(buildAwsValue())
}
object OptedOutFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.OptedOutFilter =
      zio.aws.pinpointsmsvoicev2.model.OptedOutFilter(name, values)
    def name: zio.aws.pinpointsmsvoicev2.model.OptedOutFilterName
    def values: List[FilterValue]
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.pinpointsmsvoicev2.model.OptedOutFilterName
    ] = ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutFilter
  ) extends zio.aws.pinpointsmsvoicev2.model.OptedOutFilter.ReadOnly {
    override val name: zio.aws.pinpointsmsvoicev2.model.OptedOutFilterName =
      zio.aws.pinpointsmsvoicev2.model.OptedOutFilterName.wrap(impl.name())
    override val values: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.pinpointsmsvoicev2.model.primitives.FilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutFilter
  ): zio.aws.pinpointsmsvoicev2.model.OptedOutFilter.ReadOnly = new Wrapper(
    impl
  )
}
