package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.IsoCountryCode
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class OriginationIdentityMetadata(
    originationIdentityArn: String,
    originationIdentity: String,
    isoCountryCode: IsoCountryCode,
    numberCapabilities: Iterable[
      zio.aws.pinpointsmsvoicev2.model.NumberCapability
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.OriginationIdentityMetadata = {
    import OriginationIdentityMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.OriginationIdentityMetadata
      .builder()
      .originationIdentityArn(originationIdentityArn: java.lang.String)
      .originationIdentity(originationIdentity: java.lang.String)
      .isoCountryCode(IsoCountryCode.unwrap(isoCountryCode): java.lang.String)
      .numberCapabilitiesWithStrings(numberCapabilities.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.OriginationIdentityMetadata.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.OriginationIdentityMetadata
      .wrap(buildAwsValue())
}
object OriginationIdentityMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.OriginationIdentityMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.OriginationIdentityMetadata =
      zio.aws.pinpointsmsvoicev2.model.OriginationIdentityMetadata(
        originationIdentityArn,
        originationIdentity,
        isoCountryCode,
        numberCapabilities
      )
    def originationIdentityArn: String
    def originationIdentity: String
    def isoCountryCode: IsoCountryCode
    def numberCapabilities
        : List[zio.aws.pinpointsmsvoicev2.model.NumberCapability]
    def getOriginationIdentityArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(originationIdentityArn)
    def getOriginationIdentity: ZIO[Any, Nothing, String] =
      ZIO.succeed(originationIdentity)
    def getIsoCountryCode: ZIO[Any, Nothing, IsoCountryCode] =
      ZIO.succeed(isoCountryCode)
    def getNumberCapabilities: ZIO[Any, Nothing, List[
      zio.aws.pinpointsmsvoicev2.model.NumberCapability
    ]] = ZIO.succeed(numberCapabilities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.OriginationIdentityMetadata
  ) extends zio.aws.pinpointsmsvoicev2.model.OriginationIdentityMetadata.ReadOnly {
    override val originationIdentityArn: String =
      impl.originationIdentityArn(): String
    override val originationIdentity: String =
      impl.originationIdentity(): String
    override val isoCountryCode: IsoCountryCode =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .IsoCountryCode(impl.isoCountryCode())
    override val numberCapabilities
        : List[zio.aws.pinpointsmsvoicev2.model.NumberCapability] = impl
      .numberCapabilities()
      .asScala
      .map { item =>
        zio.aws.pinpointsmsvoicev2.model.NumberCapability.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.OriginationIdentityMetadata
  ): zio.aws.pinpointsmsvoicev2.model.OriginationIdentityMetadata.ReadOnly =
    new Wrapper(impl)
}
