package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.FilterValue
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PhoneNumberFilter(
    name: zio.aws.pinpointsmsvoicev2.model.PhoneNumberFilterName,
    values: Iterable[FilterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.PhoneNumberFilter = {
    import PhoneNumberFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.PhoneNumberFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        FilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.pinpointsmsvoicev2.model.PhoneNumberFilter.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.PhoneNumberFilter.wrap(buildAwsValue())
}
object PhoneNumberFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.PhoneNumberFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.PhoneNumberFilter =
      zio.aws.pinpointsmsvoicev2.model.PhoneNumberFilter(name, values)
    def name: zio.aws.pinpointsmsvoicev2.model.PhoneNumberFilterName
    def values: List[FilterValue]
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.pinpointsmsvoicev2.model.PhoneNumberFilterName
    ] = ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.PhoneNumberFilter
  ) extends zio.aws.pinpointsmsvoicev2.model.PhoneNumberFilter.ReadOnly {
    override val name: zio.aws.pinpointsmsvoicev2.model.PhoneNumberFilterName =
      zio.aws.pinpointsmsvoicev2.model.PhoneNumberFilterName.wrap(impl.name())
    override val values: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.pinpointsmsvoicev2.model.primitives.FilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.PhoneNumberFilter
  ): zio.aws.pinpointsmsvoicev2.model.PhoneNumberFilter.ReadOnly = new Wrapper(
    impl
  )
}
