package zio.aws.pinpointsmsvoicev2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  TwoWayChannelArn,
  PrimitiveBoolean,
  Timestamp,
  IsoCountryCode,
  OptOutListName,
  PhoneNumber
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class PhoneNumberInformation(
    phoneNumberArn: String,
    phoneNumberId: Optional[String] = Optional.Absent,
    phoneNumber: PhoneNumber,
    status: zio.aws.pinpointsmsvoicev2.model.NumberStatus,
    isoCountryCode: IsoCountryCode,
    messageType: zio.aws.pinpointsmsvoicev2.model.MessageType,
    numberCapabilities: Iterable[
      zio.aws.pinpointsmsvoicev2.model.NumberCapability
    ],
    numberType: zio.aws.pinpointsmsvoicev2.model.NumberType,
    monthlyLeasingPrice: String,
    twoWayEnabled: PrimitiveBoolean,
    twoWayChannelArn: Optional[TwoWayChannelArn] = Optional.Absent,
    selfManagedOptOutsEnabled: PrimitiveBoolean,
    optOutListName: OptOutListName,
    deletionProtectionEnabled: PrimitiveBoolean,
    poolId: Optional[String] = Optional.Absent,
    createdTimestamp: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.PhoneNumberInformation = {
    import PhoneNumberInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.PhoneNumberInformation
      .builder()
      .phoneNumberArn(phoneNumberArn: java.lang.String)
      .optionallyWith(phoneNumberId.map(value => value: java.lang.String))(
        _.phoneNumberId
      )
      .phoneNumber(PhoneNumber.unwrap(phoneNumber): java.lang.String)
      .status(status.unwrap)
      .isoCountryCode(IsoCountryCode.unwrap(isoCountryCode): java.lang.String)
      .messageType(messageType.unwrap)
      .numberCapabilitiesWithStrings(numberCapabilities.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .numberType(numberType.unwrap)
      .monthlyLeasingPrice(monthlyLeasingPrice: java.lang.String)
      .twoWayEnabled(PrimitiveBoolean.unwrap(twoWayEnabled): java.lang.Boolean)
      .optionallyWith(
        twoWayChannelArn.map(value =>
          TwoWayChannelArn.unwrap(value): java.lang.String
        )
      )(_.twoWayChannelArn)
      .selfManagedOptOutsEnabled(
        PrimitiveBoolean.unwrap(selfManagedOptOutsEnabled): java.lang.Boolean
      )
      .optOutListName(OptOutListName.unwrap(optOutListName): java.lang.String)
      .deletionProtectionEnabled(
        PrimitiveBoolean.unwrap(deletionProtectionEnabled): java.lang.Boolean
      )
      .optionallyWith(poolId.map(value => value: java.lang.String))(_.poolId)
      .createdTimestamp(Timestamp.unwrap(createdTimestamp): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.PhoneNumberInformation.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.PhoneNumberInformation
      .wrap(buildAwsValue())
}
object PhoneNumberInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.PhoneNumberInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.PhoneNumberInformation =
      zio.aws.pinpointsmsvoicev2.model.PhoneNumberInformation(
        phoneNumberArn,
        phoneNumberId.map(value => value),
        phoneNumber,
        status,
        isoCountryCode,
        messageType,
        numberCapabilities,
        numberType,
        monthlyLeasingPrice,
        twoWayEnabled,
        twoWayChannelArn.map(value => value),
        selfManagedOptOutsEnabled,
        optOutListName,
        deletionProtectionEnabled,
        poolId.map(value => value),
        createdTimestamp
      )
    def phoneNumberArn: String
    def phoneNumberId: Optional[String]
    def phoneNumber: PhoneNumber
    def status: zio.aws.pinpointsmsvoicev2.model.NumberStatus
    def isoCountryCode: IsoCountryCode
    def messageType: zio.aws.pinpointsmsvoicev2.model.MessageType
    def numberCapabilities
        : List[zio.aws.pinpointsmsvoicev2.model.NumberCapability]
    def numberType: zio.aws.pinpointsmsvoicev2.model.NumberType
    def monthlyLeasingPrice: String
    def twoWayEnabled: PrimitiveBoolean
    def twoWayChannelArn: Optional[TwoWayChannelArn]
    def selfManagedOptOutsEnabled: PrimitiveBoolean
    def optOutListName: OptOutListName
    def deletionProtectionEnabled: PrimitiveBoolean
    def poolId: Optional[String]
    def createdTimestamp: Timestamp
    def getPhoneNumberArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(phoneNumberArn)
    def getPhoneNumberId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("phoneNumberId", phoneNumberId)
    def getPhoneNumber: ZIO[Any, Nothing, PhoneNumber] =
      ZIO.succeed(phoneNumber)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.pinpointsmsvoicev2.model.NumberStatus] =
      ZIO.succeed(status)
    def getIsoCountryCode: ZIO[Any, Nothing, IsoCountryCode] =
      ZIO.succeed(isoCountryCode)
    def getMessageType
        : ZIO[Any, Nothing, zio.aws.pinpointsmsvoicev2.model.MessageType] =
      ZIO.succeed(messageType)
    def getNumberCapabilities: ZIO[Any, Nothing, List[
      zio.aws.pinpointsmsvoicev2.model.NumberCapability
    ]] = ZIO.succeed(numberCapabilities)
    def getNumberType
        : ZIO[Any, Nothing, zio.aws.pinpointsmsvoicev2.model.NumberType] =
      ZIO.succeed(numberType)
    def getMonthlyLeasingPrice: ZIO[Any, Nothing, String] =
      ZIO.succeed(monthlyLeasingPrice)
    def getTwoWayEnabled: ZIO[Any, Nothing, PrimitiveBoolean] =
      ZIO.succeed(twoWayEnabled)
    def getTwoWayChannelArn: ZIO[Any, AwsError, TwoWayChannelArn] =
      AwsError.unwrapOptionField("twoWayChannelArn", twoWayChannelArn)
    def getSelfManagedOptOutsEnabled: ZIO[Any, Nothing, PrimitiveBoolean] =
      ZIO.succeed(selfManagedOptOutsEnabled)
    def getOptOutListName: ZIO[Any, Nothing, OptOutListName] =
      ZIO.succeed(optOutListName)
    def getDeletionProtectionEnabled: ZIO[Any, Nothing, PrimitiveBoolean] =
      ZIO.succeed(deletionProtectionEnabled)
    def getPoolId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("poolId", poolId)
    def getCreatedTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(createdTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.PhoneNumberInformation
  ) extends zio.aws.pinpointsmsvoicev2.model.PhoneNumberInformation.ReadOnly {
    override val phoneNumberArn: String = impl.phoneNumberArn(): String
    override val phoneNumberId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumberId())
      .map(value => value: String)
    override val phoneNumber: PhoneNumber =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PhoneNumber(impl.phoneNumber())
    override val status: zio.aws.pinpointsmsvoicev2.model.NumberStatus =
      zio.aws.pinpointsmsvoicev2.model.NumberStatus.wrap(impl.status())
    override val isoCountryCode: IsoCountryCode =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .IsoCountryCode(impl.isoCountryCode())
    override val messageType: zio.aws.pinpointsmsvoicev2.model.MessageType =
      zio.aws.pinpointsmsvoicev2.model.MessageType.wrap(impl.messageType())
    override val numberCapabilities
        : List[zio.aws.pinpointsmsvoicev2.model.NumberCapability] = impl
      .numberCapabilities()
      .asScala
      .map { item =>
        zio.aws.pinpointsmsvoicev2.model.NumberCapability.wrap(item)
      }
      .toList
    override val numberType: zio.aws.pinpointsmsvoicev2.model.NumberType =
      zio.aws.pinpointsmsvoicev2.model.NumberType.wrap(impl.numberType())
    override val monthlyLeasingPrice: String =
      impl.monthlyLeasingPrice(): String
    override val twoWayEnabled: PrimitiveBoolean =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PrimitiveBoolean(impl.twoWayEnabled())
    override val twoWayChannelArn: Optional[TwoWayChannelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.twoWayChannelArn())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.TwoWayChannelArn(value)
        )
    override val selfManagedOptOutsEnabled: PrimitiveBoolean =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PrimitiveBoolean(impl.selfManagedOptOutsEnabled())
    override val optOutListName: OptOutListName =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .OptOutListName(impl.optOutListName())
    override val deletionProtectionEnabled: PrimitiveBoolean =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PrimitiveBoolean(impl.deletionProtectionEnabled())
    override val poolId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.poolId())
      .map(value => value: String)
    override val createdTimestamp: Timestamp =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .Timestamp(impl.createdTimestamp())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.PhoneNumberInformation
  ): zio.aws.pinpointsmsvoicev2.model.PhoneNumberInformation.ReadOnly =
    new Wrapper(impl)
}
