package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.FilterValue
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PoolFilter(
    name: zio.aws.pinpointsmsvoicev2.model.PoolFilterName,
    values: Iterable[FilterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolFilter = {
    import PoolFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        FilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.pinpointsmsvoicev2.model.PoolFilter.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.PoolFilter.wrap(buildAwsValue())
}
object PoolFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.PoolFilter =
      zio.aws.pinpointsmsvoicev2.model.PoolFilter(name, values)
    def name: zio.aws.pinpointsmsvoicev2.model.PoolFilterName
    def values: List[FilterValue]
    def getName
        : ZIO[Any, Nothing, zio.aws.pinpointsmsvoicev2.model.PoolFilterName] =
      ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolFilter
  ) extends zio.aws.pinpointsmsvoicev2.model.PoolFilter.ReadOnly {
    override val name: zio.aws.pinpointsmsvoicev2.model.PoolFilterName =
      zio.aws.pinpointsmsvoicev2.model.PoolFilterName.wrap(impl.name())
    override val values: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.pinpointsmsvoicev2.model.primitives.FilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolFilter
  ): zio.aws.pinpointsmsvoicev2.model.PoolFilter.ReadOnly = new Wrapper(impl)
}
