package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.FilterValue
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PoolOriginationIdentitiesFilter(
    name: zio.aws.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilterName,
    values: Iterable[FilterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilter = {
    import PoolOriginationIdentitiesFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        FilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilter.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilter
      .wrap(buildAwsValue())
}
object PoolOriginationIdentitiesFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilter =
      zio.aws.pinpointsmsvoicev2.model
        .PoolOriginationIdentitiesFilter(name, values)
    def name
        : zio.aws.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilterName
    def values: List[FilterValue]
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilterName
    ] = ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilter
  ) extends zio.aws.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilter.ReadOnly {
    override val name
        : zio.aws.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilterName =
      zio.aws.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilterName
        .wrap(impl.name())
    override val values: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.pinpointsmsvoicev2.model.primitives.FilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilter
  ): zio.aws.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilter.ReadOnly =
    new Wrapper(impl)
}
