package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  KeywordMessage,
  Keyword,
  PhoneOrPoolIdOrArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutKeywordRequest(
    originationIdentity: PhoneOrPoolIdOrArn,
    keyword: Keyword,
    keywordMessage: KeywordMessage,
    keywordAction: Optional[zio.aws.pinpointsmsvoicev2.model.KeywordAction] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutKeywordRequest = {
    import PutKeywordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutKeywordRequest
      .builder()
      .originationIdentity(
        PhoneOrPoolIdOrArn.unwrap(originationIdentity): java.lang.String
      )
      .keyword(Keyword.unwrap(keyword): java.lang.String)
      .keywordMessage(KeywordMessage.unwrap(keywordMessage): java.lang.String)
      .optionallyWith(keywordAction.map(value => value.unwrap))(_.keywordAction)
      .build()
  }
  def asReadOnly: zio.aws.pinpointsmsvoicev2.model.PutKeywordRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.PutKeywordRequest.wrap(buildAwsValue())
}
object PutKeywordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutKeywordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.PutKeywordRequest =
      zio.aws.pinpointsmsvoicev2.model.PutKeywordRequest(
        originationIdentity,
        keyword,
        keywordMessage,
        keywordAction.map(value => value)
      )
    def originationIdentity: PhoneOrPoolIdOrArn
    def keyword: Keyword
    def keywordMessage: KeywordMessage
    def keywordAction: Optional[zio.aws.pinpointsmsvoicev2.model.KeywordAction]
    def getOriginationIdentity: ZIO[Any, Nothing, PhoneOrPoolIdOrArn] =
      ZIO.succeed(originationIdentity)
    def getKeyword: ZIO[Any, Nothing, Keyword] = ZIO.succeed(keyword)
    def getKeywordMessage: ZIO[Any, Nothing, KeywordMessage] =
      ZIO.succeed(keywordMessage)
    def getKeywordAction
        : ZIO[Any, AwsError, zio.aws.pinpointsmsvoicev2.model.KeywordAction] =
      AwsError.unwrapOptionField("keywordAction", keywordAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutKeywordRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.PutKeywordRequest.ReadOnly {
    override val originationIdentity: PhoneOrPoolIdOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PhoneOrPoolIdOrArn(impl.originationIdentity())
    override val keyword: Keyword =
      zio.aws.pinpointsmsvoicev2.model.primitives.Keyword(impl.keyword())
    override val keywordMessage: KeywordMessage =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .KeywordMessage(impl.keywordMessage())
    override val keywordAction
        : Optional[zio.aws.pinpointsmsvoicev2.model.KeywordAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keywordAction())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.KeywordAction.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutKeywordRequest
  ): zio.aws.pinpointsmsvoicev2.model.PutKeywordRequest.ReadOnly = new Wrapper(
    impl
  )
}
