package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  PhoneNumber,
  OptOutListNameOrArn
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutOptedOutNumberRequest(
    optOutListName: OptOutListNameOrArn,
    optedOutNumber: PhoneNumber
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutOptedOutNumberRequest = {
    import PutOptedOutNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutOptedOutNumberRequest
      .builder()
      .optOutListName(
        OptOutListNameOrArn.unwrap(optOutListName): java.lang.String
      )
      .optedOutNumber(PhoneNumber.unwrap(optedOutNumber): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.PutOptedOutNumberRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.PutOptedOutNumberRequest
      .wrap(buildAwsValue())
}
object PutOptedOutNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutOptedOutNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.PutOptedOutNumberRequest =
      zio.aws.pinpointsmsvoicev2.model
        .PutOptedOutNumberRequest(optOutListName, optedOutNumber)
    def optOutListName: OptOutListNameOrArn
    def optedOutNumber: PhoneNumber
    def getOptOutListName: ZIO[Any, Nothing, OptOutListNameOrArn] =
      ZIO.succeed(optOutListName)
    def getOptedOutNumber: ZIO[Any, Nothing, PhoneNumber] =
      ZIO.succeed(optedOutNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutOptedOutNumberRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.PutOptedOutNumberRequest.ReadOnly {
    override val optOutListName: OptOutListNameOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .OptOutListNameOrArn(impl.optOutListName())
    override val optedOutNumber: PhoneNumber =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PhoneNumber(impl.optedOutNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutOptedOutNumberRequest
  ): zio.aws.pinpointsmsvoicev2.model.PutOptedOutNumberRequest.ReadOnly =
    new Wrapper(impl)
}
