package zio.aws.pinpointsmsvoicev2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  TimeToLive,
  Keyword,
  ConfigurationSetNameOrArn,
  MaxPrice,
  PrimitiveBoolean,
  DestinationCountryParameterValue,
  TextMessageOriginationIdentity,
  ContextKey,
  PhoneNumber,
  ContextValue,
  TextMessageBody
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SendTextMessageRequest(
    destinationPhoneNumber: PhoneNumber,
    originationIdentity: Optional[TextMessageOriginationIdentity] =
      Optional.Absent,
    messageBody: Optional[TextMessageBody] = Optional.Absent,
    messageType: Optional[zio.aws.pinpointsmsvoicev2.model.MessageType] =
      Optional.Absent,
    keyword: Optional[Keyword] = Optional.Absent,
    configurationSetName: Optional[ConfigurationSetNameOrArn] = Optional.Absent,
    maxPrice: Optional[MaxPrice] = Optional.Absent,
    timeToLive: Optional[TimeToLive] = Optional.Absent,
    context: Optional[Map[ContextKey, ContextValue]] = Optional.Absent,
    destinationCountryParameters: Optional[Map[
      zio.aws.pinpointsmsvoicev2.model.DestinationCountryParameterKey,
      DestinationCountryParameterValue
    ]] = Optional.Absent,
    dryRun: Optional[PrimitiveBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendTextMessageRequest = {
    import SendTextMessageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendTextMessageRequest
      .builder()
      .destinationPhoneNumber(
        PhoneNumber.unwrap(destinationPhoneNumber): java.lang.String
      )
      .optionallyWith(
        originationIdentity.map(value =>
          TextMessageOriginationIdentity.unwrap(value): java.lang.String
        )
      )(_.originationIdentity)
      .optionallyWith(
        messageBody.map(value =>
          TextMessageBody.unwrap(value): java.lang.String
        )
      )(_.messageBody)
      .optionallyWith(messageType.map(value => value.unwrap))(_.messageType)
      .optionallyWith(
        keyword.map(value => Keyword.unwrap(value): java.lang.String)
      )(_.keyword)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetNameOrArn.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .optionallyWith(
        maxPrice.map(value => MaxPrice.unwrap(value): java.lang.String)
      )(_.maxPrice)
      .optionallyWith(
        timeToLive.map(value => TimeToLive.unwrap(value): Integer)
      )(_.timeToLive)
      .optionallyWith(
        context.map(value =>
          value
            .map({ case (key, value) =>
              (ContextKey.unwrap(key): java.lang.String) -> (ContextValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.context)
      .optionallyWith(
        destinationCountryParameters.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (DestinationCountryParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.destinationCountryParametersWithStrings)
      .optionallyWith(
        dryRun.map(value => PrimitiveBoolean.unwrap(value): java.lang.Boolean)
      )(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.SendTextMessageRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.SendTextMessageRequest
      .wrap(buildAwsValue())
}
object SendTextMessageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendTextMessageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.SendTextMessageRequest =
      zio.aws.pinpointsmsvoicev2.model.SendTextMessageRequest(
        destinationPhoneNumber,
        originationIdentity.map(value => value),
        messageBody.map(value => value),
        messageType.map(value => value),
        keyword.map(value => value),
        configurationSetName.map(value => value),
        maxPrice.map(value => value),
        timeToLive.map(value => value),
        context.map(value => value),
        destinationCountryParameters.map(value => value),
        dryRun.map(value => value)
      )
    def destinationPhoneNumber: PhoneNumber
    def originationIdentity: Optional[TextMessageOriginationIdentity]
    def messageBody: Optional[TextMessageBody]
    def messageType: Optional[zio.aws.pinpointsmsvoicev2.model.MessageType]
    def keyword: Optional[Keyword]
    def configurationSetName: Optional[ConfigurationSetNameOrArn]
    def maxPrice: Optional[MaxPrice]
    def timeToLive: Optional[TimeToLive]
    def context: Optional[Map[ContextKey, ContextValue]]
    def destinationCountryParameters: Optional[Map[
      zio.aws.pinpointsmsvoicev2.model.DestinationCountryParameterKey,
      DestinationCountryParameterValue
    ]]
    def dryRun: Optional[PrimitiveBoolean]
    def getDestinationPhoneNumber: ZIO[Any, Nothing, PhoneNumber] =
      ZIO.succeed(destinationPhoneNumber)
    def getOriginationIdentity
        : ZIO[Any, AwsError, TextMessageOriginationIdentity] =
      AwsError.unwrapOptionField("originationIdentity", originationIdentity)
    def getMessageBody: ZIO[Any, AwsError, TextMessageBody] =
      AwsError.unwrapOptionField("messageBody", messageBody)
    def getMessageType
        : ZIO[Any, AwsError, zio.aws.pinpointsmsvoicev2.model.MessageType] =
      AwsError.unwrapOptionField("messageType", messageType)
    def getKeyword: ZIO[Any, AwsError, Keyword] =
      AwsError.unwrapOptionField("keyword", keyword)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetNameOrArn] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
    def getMaxPrice: ZIO[Any, AwsError, MaxPrice] =
      AwsError.unwrapOptionField("maxPrice", maxPrice)
    def getTimeToLive: ZIO[Any, AwsError, TimeToLive] =
      AwsError.unwrapOptionField("timeToLive", timeToLive)
    def getContext: ZIO[Any, AwsError, Map[ContextKey, ContextValue]] =
      AwsError.unwrapOptionField("context", context)
    def getDestinationCountryParameters: ZIO[Any, AwsError, Map[
      zio.aws.pinpointsmsvoicev2.model.DestinationCountryParameterKey,
      DestinationCountryParameterValue
    ]] = AwsError.unwrapOptionField(
      "destinationCountryParameters",
      destinationCountryParameters
    )
    def getDryRun: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendTextMessageRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.SendTextMessageRequest.ReadOnly {
    override val destinationPhoneNumber: PhoneNumber =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PhoneNumber(impl.destinationPhoneNumber())
    override val originationIdentity: Optional[TextMessageOriginationIdentity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originationIdentity())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives
            .TextMessageOriginationIdentity(value)
        )
    override val messageBody: Optional[TextMessageBody] = zio.aws.core.internal
      .optionalFromNullable(impl.messageBody())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.TextMessageBody(value)
      )
    override val messageType
        : Optional[zio.aws.pinpointsmsvoicev2.model.MessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageType())
        .map(value => zio.aws.pinpointsmsvoicev2.model.MessageType.wrap(value))
    override val keyword: Optional[Keyword] = zio.aws.core.internal
      .optionalFromNullable(impl.keyword())
      .map(value => zio.aws.pinpointsmsvoicev2.model.primitives.Keyword(value))
    override val configurationSetName: Optional[ConfigurationSetNameOrArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationSetName())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives
            .ConfigurationSetNameOrArn(value)
        )
    override val maxPrice: Optional[MaxPrice] = zio.aws.core.internal
      .optionalFromNullable(impl.maxPrice())
      .map(value => zio.aws.pinpointsmsvoicev2.model.primitives.MaxPrice(value))
    override val timeToLive: Optional[TimeToLive] = zio.aws.core.internal
      .optionalFromNullable(impl.timeToLive())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.TimeToLive(value)
      )
    override val context: Optional[Map[ContextKey, ContextValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.context())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.pinpointsmsvoicev2.model.primitives
                .ContextKey(key) -> zio.aws.pinpointsmsvoicev2.model.primitives
                .ContextValue(value)
            })
            .toMap
        )
    override val destinationCountryParameters: Optional[Map[
      zio.aws.pinpointsmsvoicev2.model.DestinationCountryParameterKey,
      DestinationCountryParameterValue
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCountryParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpointsmsvoicev2.model.DestinationCountryParameterKey
              .wrap(key) -> zio.aws.pinpointsmsvoicev2.model.primitives
              .DestinationCountryParameterValue(value)
          })
          .toMap
      )
    override val dryRun: Optional[PrimitiveBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.PrimitiveBoolean(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendTextMessageRequest
  ): zio.aws.pinpointsmsvoicev2.model.SendTextMessageRequest.ReadOnly =
    new Wrapper(impl)
}
