package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SendVoiceMessageResponse(
    messageId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendVoiceMessageResponse = {
    import SendVoiceMessageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendVoiceMessageResponse
      .builder()
      .optionallyWith(messageId.map(value => value: java.lang.String))(
        _.messageId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.SendVoiceMessageResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.SendVoiceMessageResponse
      .wrap(buildAwsValue())
}
object SendVoiceMessageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendVoiceMessageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.SendVoiceMessageResponse =
      zio.aws.pinpointsmsvoicev2.model
        .SendVoiceMessageResponse(messageId.map(value => value))
    def messageId: Optional[String]
    def getMessageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("messageId", messageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendVoiceMessageResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.SendVoiceMessageResponse.ReadOnly {
    override val messageId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.messageId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendVoiceMessageResponse
  ): zio.aws.pinpointsmsvoicev2.model.SendVoiceMessageResponse.ReadOnly =
    new Wrapper(impl)
}
