package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.ConfigurationSetNameOrArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SetDefaultMessageTypeRequest(
    configurationSetName: ConfigurationSetNameOrArn,
    messageType: zio.aws.pinpointsmsvoicev2.model.MessageType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultMessageTypeRequest = {
    import SetDefaultMessageTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultMessageTypeRequest
      .builder()
      .configurationSetName(
        ConfigurationSetNameOrArn.unwrap(configurationSetName): java.lang.String
      )
      .messageType(messageType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.SetDefaultMessageTypeRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.SetDefaultMessageTypeRequest
      .wrap(buildAwsValue())
}
object SetDefaultMessageTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultMessageTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.SetDefaultMessageTypeRequest =
      zio.aws.pinpointsmsvoicev2.model
        .SetDefaultMessageTypeRequest(configurationSetName, messageType)
    def configurationSetName: ConfigurationSetNameOrArn
    def messageType: zio.aws.pinpointsmsvoicev2.model.MessageType
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetNameOrArn] =
      ZIO.succeed(configurationSetName)
    def getMessageType
        : ZIO[Any, Nothing, zio.aws.pinpointsmsvoicev2.model.MessageType] =
      ZIO.succeed(messageType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultMessageTypeRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.SetDefaultMessageTypeRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetNameOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .ConfigurationSetNameOrArn(impl.configurationSetName())
    override val messageType: zio.aws.pinpointsmsvoicev2.model.MessageType =
      zio.aws.pinpointsmsvoicev2.model.MessageType.wrap(impl.messageType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultMessageTypeRequest
  ): zio.aws.pinpointsmsvoicev2.model.SetDefaultMessageTypeRequest.ReadOnly =
    new Wrapper(impl)
}
