package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  SenderId,
  ConfigurationSetNameOrArn
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SetDefaultSenderIdRequest(
    configurationSetName: ConfigurationSetNameOrArn,
    senderId: SenderId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultSenderIdRequest = {
    import SetDefaultSenderIdRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultSenderIdRequest
      .builder()
      .configurationSetName(
        ConfigurationSetNameOrArn.unwrap(configurationSetName): java.lang.String
      )
      .senderId(SenderId.unwrap(senderId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.SetDefaultSenderIdRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.SetDefaultSenderIdRequest
      .wrap(buildAwsValue())
}
object SetDefaultSenderIdRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultSenderIdRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.SetDefaultSenderIdRequest =
      zio.aws.pinpointsmsvoicev2.model
        .SetDefaultSenderIdRequest(configurationSetName, senderId)
    def configurationSetName: ConfigurationSetNameOrArn
    def senderId: SenderId
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetNameOrArn] =
      ZIO.succeed(configurationSetName)
    def getSenderId: ZIO[Any, Nothing, SenderId] = ZIO.succeed(senderId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultSenderIdRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.SetDefaultSenderIdRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetNameOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .ConfigurationSetNameOrArn(impl.configurationSetName())
    override val senderId: SenderId =
      zio.aws.pinpointsmsvoicev2.model.primitives.SenderId(impl.senderId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultSenderIdRequest
  ): zio.aws.pinpointsmsvoicev2.model.SetDefaultSenderIdRequest.ReadOnly =
    new Wrapper(impl)
}
