package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  EventDestinationName,
  ConfigurationSetNameOrArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateEventDestinationRequest(
    configurationSetName: ConfigurationSetNameOrArn,
    eventDestinationName: EventDestinationName,
    enabled: Optional[Boolean] = Optional.Absent,
    matchingEventTypes: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.EventType]
    ] = Optional.Absent,
    cloudWatchLogsDestination: Optional[
      zio.aws.pinpointsmsvoicev2.model.CloudWatchLogsDestination
    ] = Optional.Absent,
    kinesisFirehoseDestination: Optional[
      zio.aws.pinpointsmsvoicev2.model.KinesisFirehoseDestination
    ] = Optional.Absent,
    snsDestination: Optional[zio.aws.pinpointsmsvoicev2.model.SnsDestination] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateEventDestinationRequest = {
    import UpdateEventDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateEventDestinationRequest
      .builder()
      .configurationSetName(
        ConfigurationSetNameOrArn.unwrap(configurationSetName): java.lang.String
      )
      .eventDestinationName(
        EventDestinationName.unwrap(eventDestinationName): java.lang.String
      )
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        matchingEventTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.matchingEventTypesWithStrings)
      .optionallyWith(
        cloudWatchLogsDestination.map(value => value.buildAwsValue())
      )(_.cloudWatchLogsDestination)
      .optionallyWith(
        kinesisFirehoseDestination.map(value => value.buildAwsValue())
      )(_.kinesisFirehoseDestination)
      .optionallyWith(snsDestination.map(value => value.buildAwsValue()))(
        _.snsDestination
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.UpdateEventDestinationRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.UpdateEventDestinationRequest
      .wrap(buildAwsValue())
}
object UpdateEventDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateEventDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.UpdateEventDestinationRequest =
      zio.aws.pinpointsmsvoicev2.model.UpdateEventDestinationRequest(
        configurationSetName,
        eventDestinationName,
        enabled.map(value => value),
        matchingEventTypes.map(value => value),
        cloudWatchLogsDestination.map(value => value.asEditable),
        kinesisFirehoseDestination.map(value => value.asEditable),
        snsDestination.map(value => value.asEditable)
      )
    def configurationSetName: ConfigurationSetNameOrArn
    def eventDestinationName: EventDestinationName
    def enabled: Optional[Boolean]
    def matchingEventTypes
        : Optional[List[zio.aws.pinpointsmsvoicev2.model.EventType]]
    def cloudWatchLogsDestination: Optional[
      zio.aws.pinpointsmsvoicev2.model.CloudWatchLogsDestination.ReadOnly
    ]
    def kinesisFirehoseDestination: Optional[
      zio.aws.pinpointsmsvoicev2.model.KinesisFirehoseDestination.ReadOnly
    ]
    def snsDestination
        : Optional[zio.aws.pinpointsmsvoicev2.model.SnsDestination.ReadOnly]
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetNameOrArn] =
      ZIO.succeed(configurationSetName)
    def getEventDestinationName: ZIO[Any, Nothing, EventDestinationName] =
      ZIO.succeed(eventDestinationName)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getMatchingEventTypes
        : ZIO[Any, AwsError, List[zio.aws.pinpointsmsvoicev2.model.EventType]] =
      AwsError.unwrapOptionField("matchingEventTypes", matchingEventTypes)
    def getCloudWatchLogsDestination: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.CloudWatchLogsDestination.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLogsDestination",
      cloudWatchLogsDestination
    )
    def getKinesisFirehoseDestination: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.KinesisFirehoseDestination.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisFirehoseDestination",
      kinesisFirehoseDestination
    )
    def getSnsDestination: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.SnsDestination.ReadOnly
    ] = AwsError.unwrapOptionField("snsDestination", snsDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateEventDestinationRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.UpdateEventDestinationRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetNameOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .ConfigurationSetNameOrArn(impl.configurationSetName())
    override val eventDestinationName: EventDestinationName =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .EventDestinationName(impl.eventDestinationName())
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val matchingEventTypes
        : Optional[List[zio.aws.pinpointsmsvoicev2.model.EventType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.matchingEventTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointsmsvoicev2.model.EventType.wrap(item)
          }.toList
        )
    override val cloudWatchLogsDestination: Optional[
      zio.aws.pinpointsmsvoicev2.model.CloudWatchLogsDestination.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLogsDestination())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.CloudWatchLogsDestination.wrap(value)
      )
    override val kinesisFirehoseDestination: Optional[
      zio.aws.pinpointsmsvoicev2.model.KinesisFirehoseDestination.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisFirehoseDestination())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.KinesisFirehoseDestination.wrap(value)
      )
    override val snsDestination
        : Optional[zio.aws.pinpointsmsvoicev2.model.SnsDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snsDestination())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.SnsDestination.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateEventDestinationRequest
  ): zio.aws.pinpointsmsvoicev2.model.UpdateEventDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
