package zio.aws.pinpointsmsvoicev2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  TwoWayChannelArn,
  PrimitiveBoolean,
  Timestamp,
  IsoCountryCode,
  OptOutListName,
  PhoneNumber
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class UpdatePhoneNumberResponse(
    phoneNumberArn: Optional[String] = Optional.Absent,
    phoneNumberId: Optional[String] = Optional.Absent,
    phoneNumber: Optional[PhoneNumber] = Optional.Absent,
    status: Optional[zio.aws.pinpointsmsvoicev2.model.NumberStatus] =
      Optional.Absent,
    isoCountryCode: Optional[IsoCountryCode] = Optional.Absent,
    messageType: Optional[zio.aws.pinpointsmsvoicev2.model.MessageType] =
      Optional.Absent,
    numberCapabilities: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.NumberCapability]
    ] = Optional.Absent,
    numberType: Optional[zio.aws.pinpointsmsvoicev2.model.NumberType] =
      Optional.Absent,
    monthlyLeasingPrice: Optional[String] = Optional.Absent,
    twoWayEnabled: Optional[PrimitiveBoolean] = Optional.Absent,
    twoWayChannelArn: Optional[TwoWayChannelArn] = Optional.Absent,
    selfManagedOptOutsEnabled: Optional[PrimitiveBoolean] = Optional.Absent,
    optOutListName: Optional[OptOutListName] = Optional.Absent,
    deletionProtectionEnabled: Optional[PrimitiveBoolean] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse = {
    import UpdatePhoneNumberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse
      .builder()
      .optionallyWith(phoneNumberArn.map(value => value: java.lang.String))(
        _.phoneNumberArn
      )
      .optionallyWith(phoneNumberId.map(value => value: java.lang.String))(
        _.phoneNumberId
      )
      .optionallyWith(
        phoneNumber.map(value => PhoneNumber.unwrap(value): java.lang.String)
      )(_.phoneNumber)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        isoCountryCode.map(value =>
          IsoCountryCode.unwrap(value): java.lang.String
        )
      )(_.isoCountryCode)
      .optionallyWith(messageType.map(value => value.unwrap))(_.messageType)
      .optionallyWith(
        numberCapabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.numberCapabilitiesWithStrings)
      .optionallyWith(numberType.map(value => value.unwrap))(_.numberType)
      .optionallyWith(
        monthlyLeasingPrice.map(value => value: java.lang.String)
      )(_.monthlyLeasingPrice)
      .optionallyWith(
        twoWayEnabled.map(value =>
          PrimitiveBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.twoWayEnabled)
      .optionallyWith(
        twoWayChannelArn.map(value =>
          TwoWayChannelArn.unwrap(value): java.lang.String
        )
      )(_.twoWayChannelArn)
      .optionallyWith(
        selfManagedOptOutsEnabled.map(value =>
          PrimitiveBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.selfManagedOptOutsEnabled)
      .optionallyWith(
        optOutListName.map(value =>
          OptOutListName.unwrap(value): java.lang.String
        )
      )(_.optOutListName)
      .optionallyWith(
        deletionProtectionEnabled.map(value =>
          PrimitiveBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.deletionProtectionEnabled)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse
      .wrap(buildAwsValue())
}
object UpdatePhoneNumberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse =
      zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse(
        phoneNumberArn.map(value => value),
        phoneNumberId.map(value => value),
        phoneNumber.map(value => value),
        status.map(value => value),
        isoCountryCode.map(value => value),
        messageType.map(value => value),
        numberCapabilities.map(value => value),
        numberType.map(value => value),
        monthlyLeasingPrice.map(value => value),
        twoWayEnabled.map(value => value),
        twoWayChannelArn.map(value => value),
        selfManagedOptOutsEnabled.map(value => value),
        optOutListName.map(value => value),
        deletionProtectionEnabled.map(value => value),
        createdTimestamp.map(value => value)
      )
    def phoneNumberArn: Optional[String]
    def phoneNumberId: Optional[String]
    def phoneNumber: Optional[PhoneNumber]
    def status: Optional[zio.aws.pinpointsmsvoicev2.model.NumberStatus]
    def isoCountryCode: Optional[IsoCountryCode]
    def messageType: Optional[zio.aws.pinpointsmsvoicev2.model.MessageType]
    def numberCapabilities
        : Optional[List[zio.aws.pinpointsmsvoicev2.model.NumberCapability]]
    def numberType: Optional[zio.aws.pinpointsmsvoicev2.model.NumberType]
    def monthlyLeasingPrice: Optional[String]
    def twoWayEnabled: Optional[PrimitiveBoolean]
    def twoWayChannelArn: Optional[TwoWayChannelArn]
    def selfManagedOptOutsEnabled: Optional[PrimitiveBoolean]
    def optOutListName: Optional[OptOutListName]
    def deletionProtectionEnabled: Optional[PrimitiveBoolean]
    def createdTimestamp: Optional[Timestamp]
    def getPhoneNumberArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("phoneNumberArn", phoneNumberArn)
    def getPhoneNumberId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("phoneNumberId", phoneNumberId)
    def getPhoneNumber: ZIO[Any, AwsError, PhoneNumber] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.pinpointsmsvoicev2.model.NumberStatus] =
      AwsError.unwrapOptionField("status", status)
    def getIsoCountryCode: ZIO[Any, AwsError, IsoCountryCode] =
      AwsError.unwrapOptionField("isoCountryCode", isoCountryCode)
    def getMessageType
        : ZIO[Any, AwsError, zio.aws.pinpointsmsvoicev2.model.MessageType] =
      AwsError.unwrapOptionField("messageType", messageType)
    def getNumberCapabilities: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.NumberCapability
    ]] = AwsError.unwrapOptionField("numberCapabilities", numberCapabilities)
    def getNumberType
        : ZIO[Any, AwsError, zio.aws.pinpointsmsvoicev2.model.NumberType] =
      AwsError.unwrapOptionField("numberType", numberType)
    def getMonthlyLeasingPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("monthlyLeasingPrice", monthlyLeasingPrice)
    def getTwoWayEnabled: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField("twoWayEnabled", twoWayEnabled)
    def getTwoWayChannelArn: ZIO[Any, AwsError, TwoWayChannelArn] =
      AwsError.unwrapOptionField("twoWayChannelArn", twoWayChannelArn)
    def getSelfManagedOptOutsEnabled: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField(
        "selfManagedOptOutsEnabled",
        selfManagedOptOutsEnabled
      )
    def getOptOutListName: ZIO[Any, AwsError, OptOutListName] =
      AwsError.unwrapOptionField("optOutListName", optOutListName)
    def getDeletionProtectionEnabled: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField(
        "deletionProtectionEnabled",
        deletionProtectionEnabled
      )
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse.ReadOnly {
    override val phoneNumberArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumberArn())
      .map(value => value: String)
    override val phoneNumberId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumberId())
      .map(value => value: String)
    override val phoneNumber: Optional[PhoneNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumber())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.PhoneNumber(value)
      )
    override val status
        : Optional[zio.aws.pinpointsmsvoicev2.model.NumberStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.pinpointsmsvoicev2.model.NumberStatus.wrap(value))
    override val isoCountryCode: Optional[IsoCountryCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isoCountryCode())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.IsoCountryCode(value)
        )
    override val messageType
        : Optional[zio.aws.pinpointsmsvoicev2.model.MessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageType())
        .map(value => zio.aws.pinpointsmsvoicev2.model.MessageType.wrap(value))
    override val numberCapabilities
        : Optional[List[zio.aws.pinpointsmsvoicev2.model.NumberCapability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberCapabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointsmsvoicev2.model.NumberCapability.wrap(item)
          }.toList
        )
    override val numberType
        : Optional[zio.aws.pinpointsmsvoicev2.model.NumberType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberType())
        .map(value => zio.aws.pinpointsmsvoicev2.model.NumberType.wrap(value))
    override val monthlyLeasingPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.monthlyLeasingPrice())
      .map(value => value: String)
    override val twoWayEnabled: Optional[PrimitiveBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.twoWayEnabled())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.PrimitiveBoolean(value)
        )
    override val twoWayChannelArn: Optional[TwoWayChannelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.twoWayChannelArn())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.TwoWayChannelArn(value)
        )
    override val selfManagedOptOutsEnabled: Optional[PrimitiveBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selfManagedOptOutsEnabled())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.PrimitiveBoolean(value)
        )
    override val optOutListName: Optional[OptOutListName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optOutListName())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.OptOutListName(value)
        )
    override val deletionProtectionEnabled: Optional[PrimitiveBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtectionEnabled())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.PrimitiveBoolean(value)
        )
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.Timestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse
  ): zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse.ReadOnly =
    new Wrapper(impl)
}
