package zio.aws.pinpointsmsvoicev2
import zio.prelude.Subtype
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  Keyword,
  ConfigurationSetNameOrArn,
  PhoneNumberIdOrArn,
  PoolIdOrArn,
  DestinationCountryParameterValue,
  ContextKey,
  PhoneNumber,
  ContextValue,
  OptOutListNameOrArn,
  FilterValue,
  TagKey
}
import java.time.Instant
import zio.aws.pinpointsmsvoicev2.model.primitives.PhoneNumberIdOrArn.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.pinpointsmsvoicev2.model.primitives.AmazonResourceName.Type
    object ClientToken extends Subtype[String]
    type ClientToken =
      zio.aws.pinpointsmsvoicev2.model.primitives.ClientToken.Type
    object ConfigurationSetName extends Subtype[String]
    type ConfigurationSetName =
      zio.aws.pinpointsmsvoicev2.model.primitives.ConfigurationSetName.Type
    object ConfigurationSetNameOrArn extends Subtype[String]
    type ConfigurationSetNameOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives.ConfigurationSetNameOrArn.Type
    object ContextKey extends Subtype[String]
    type ContextKey =
      zio.aws.pinpointsmsvoicev2.model.primitives.ContextKey.Type
    object ContextValue extends Subtype[String]
    type ContextValue =
      zio.aws.pinpointsmsvoicev2.model.primitives.ContextValue.Type
    object DeliveryStreamArn extends Subtype[String]
    type DeliveryStreamArn =
      zio.aws.pinpointsmsvoicev2.model.primitives.DeliveryStreamArn.Type
    object DestinationCountryParameterValue extends Subtype[String]
    type DestinationCountryParameterValue =
      zio.aws.pinpointsmsvoicev2.model.primitives.DestinationCountryParameterValue.Type
    object EventDestinationName extends Subtype[String]
    type EventDestinationName =
      zio.aws.pinpointsmsvoicev2.model.primitives.EventDestinationName.Type
    object FilterValue extends Subtype[String]
    type FilterValue =
      zio.aws.pinpointsmsvoicev2.model.primitives.FilterValue.Type
    object IamRoleArn extends Subtype[String]
    type IamRoleArn =
      zio.aws.pinpointsmsvoicev2.model.primitives.IamRoleArn.Type
    object IsoCountryCode extends Subtype[String]
    type IsoCountryCode =
      zio.aws.pinpointsmsvoicev2.model.primitives.IsoCountryCode.Type
    object Keyword extends Subtype[String]
    type Keyword = zio.aws.pinpointsmsvoicev2.model.primitives.Keyword.Type
    object KeywordMessage extends Subtype[String]
    type KeywordMessage =
      zio.aws.pinpointsmsvoicev2.model.primitives.KeywordMessage.Type
    object LogGroupArn extends Subtype[String]
    type LogGroupArn =
      zio.aws.pinpointsmsvoicev2.model.primitives.LogGroupArn.Type
    object MaxPrice extends Subtype[String]
    type MaxPrice = zio.aws.pinpointsmsvoicev2.model.primitives.MaxPrice.Type
    object MaxResults extends Subtype[Int]
    type MaxResults =
      zio.aws.pinpointsmsvoicev2.model.primitives.MaxResults.Type
    object MonthlyLimit extends Subtype[Long]
    type MonthlyLimit =
      zio.aws.pinpointsmsvoicev2.model.primitives.MonthlyLimit.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.pinpointsmsvoicev2.model.primitives.NextToken.Type
    object OptOutListName extends Subtype[String]
    type OptOutListName =
      zio.aws.pinpointsmsvoicev2.model.primitives.OptOutListName.Type
    object OptOutListNameOrArn extends Subtype[String]
    type OptOutListNameOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives.OptOutListNameOrArn.Type
    object PhoneNumber extends Subtype[String]
    type PhoneNumber =
      zio.aws.pinpointsmsvoicev2.model.primitives.PhoneNumber.Type
    object PhoneNumberIdOrArn extends Subtype[String]
    type PhoneNumberIdOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives.PhoneNumberIdOrArn.Type
    object PhoneOrPoolIdOrArn extends Subtype[String]
    type PhoneOrPoolIdOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives.PhoneOrPoolIdOrArn.Type
    object PhoneOrSenderIdOrArn extends Subtype[String]
    type PhoneOrSenderIdOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives.PhoneOrSenderIdOrArn.Type
    object PoolIdOrArn extends Subtype[String]
    type PoolIdOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives.PoolIdOrArn.Type
    object PrimitiveBoolean extends Subtype[Boolean]
    type PrimitiveBoolean =
      zio.aws.pinpointsmsvoicev2.model.primitives.PrimitiveBoolean.Type
    object PrimitiveLong extends Subtype[Long]
    type PrimitiveLong =
      zio.aws.pinpointsmsvoicev2.model.primitives.PrimitiveLong.Type
    object RegistrationId extends Subtype[String]
    type RegistrationId =
      zio.aws.pinpointsmsvoicev2.model.primitives.RegistrationId.Type
    object SenderId extends Subtype[String]
    type SenderId = zio.aws.pinpointsmsvoicev2.model.primitives.SenderId.Type
    object SenderIdOrArn extends Subtype[String]
    type SenderIdOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives.SenderIdOrArn.Type
    object SnsTopicArn extends Subtype[String]
    type SnsTopicArn =
      zio.aws.pinpointsmsvoicev2.model.primitives.SnsTopicArn.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.pinpointsmsvoicev2.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.pinpointsmsvoicev2.model.primitives.TagValue.Type
    object TextMessageBody extends Subtype[String]
    type TextMessageBody =
      zio.aws.pinpointsmsvoicev2.model.primitives.TextMessageBody.Type
    object TextMessageOriginationIdentity extends Subtype[String]
    type TextMessageOriginationIdentity =
      zio.aws.pinpointsmsvoicev2.model.primitives.TextMessageOriginationIdentity.Type
    object TimeToLive extends Subtype[Int]
    type TimeToLive =
      zio.aws.pinpointsmsvoicev2.model.primitives.TimeToLive.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.pinpointsmsvoicev2.model.primitives.Timestamp.Type
    object TwoWayChannelArn extends Subtype[String]
    type TwoWayChannelArn =
      zio.aws.pinpointsmsvoicev2.model.primitives.TwoWayChannelArn.Type
    object VoiceMessageBody extends Subtype[String]
    type VoiceMessageBody =
      zio.aws.pinpointsmsvoicev2.model.primitives.VoiceMessageBody.Type
    object VoiceMessageOriginationIdentity extends Subtype[String]
    type VoiceMessageOriginationIdentity =
      zio.aws.pinpointsmsvoicev2.model.primitives.VoiceMessageOriginationIdentity.Type
  }
  type AccountAttributeList =
    List[zio.aws.pinpointsmsvoicev2.model.AccountAttribute]
  type AccountLimitList = List[zio.aws.pinpointsmsvoicev2.model.AccountLimit]
  type ConfigurationSetFilterList =
    List[zio.aws.pinpointsmsvoicev2.model.ConfigurationSetFilter]
  type ConfigurationSetInformationList =
    List[zio.aws.pinpointsmsvoicev2.model.ConfigurationSetInformation]
  type ConfigurationSetNameList = List[ConfigurationSetNameOrArn]
  type ContextMap = Map[ContextKey, ContextValue]
  type DestinationCountryParameters = Map[
    zio.aws.pinpointsmsvoicev2.model.DestinationCountryParameterKey,
    DestinationCountryParameterValue
  ]
  type EventDestinationList =
    List[zio.aws.pinpointsmsvoicev2.model.EventDestination]
  type EventTypeList = List[zio.aws.pinpointsmsvoicev2.model.EventType]
  type FilterValueList = List[FilterValue]
  type KeywordFilterList = List[zio.aws.pinpointsmsvoicev2.model.KeywordFilter]
  type KeywordInformationList =
    List[zio.aws.pinpointsmsvoicev2.model.KeywordInformation]
  type KeywordList = List[Keyword]
  type MessageTypeList = List[zio.aws.pinpointsmsvoicev2.model.MessageType]
  type NonEmptyTagList = List[zio.aws.pinpointsmsvoicev2.model.Tag]
  type NumberCapabilityList =
    List[zio.aws.pinpointsmsvoicev2.model.NumberCapability]
  type OptOutListInformationList =
    List[zio.aws.pinpointsmsvoicev2.model.OptOutListInformation]
  type OptOutListNameList = List[OptOutListNameOrArn]
  type OptedOutFilterList =
    List[zio.aws.pinpointsmsvoicev2.model.OptedOutFilter]
  type OptedOutNumberInformationList =
    List[zio.aws.pinpointsmsvoicev2.model.OptedOutNumberInformation]
  type OptedOutNumberList = List[PhoneNumber]
  type OriginationIdentityMetadataList =
    List[zio.aws.pinpointsmsvoicev2.model.OriginationIdentityMetadata]
  type PhoneNumberFilterList =
    List[zio.aws.pinpointsmsvoicev2.model.PhoneNumberFilter]
  type PhoneNumberIdList = List[PhoneNumberIdOrArn]
  type PhoneNumberInformationList =
    List[zio.aws.pinpointsmsvoicev2.model.PhoneNumberInformation]
  type PoolFilterList = List[zio.aws.pinpointsmsvoicev2.model.PoolFilter]
  type PoolIdList = List[PoolIdOrArn]
  type PoolInformationList =
    List[zio.aws.pinpointsmsvoicev2.model.PoolInformation]
  type PoolOriginationIdentitiesFilterList =
    List[zio.aws.pinpointsmsvoicev2.model.PoolOriginationIdentitiesFilter]
  type SenderIdFilterList =
    List[zio.aws.pinpointsmsvoicev2.model.SenderIdFilter]
  type SenderIdInformationList =
    List[zio.aws.pinpointsmsvoicev2.model.SenderIdInformation]
  type SenderIdList = List[zio.aws.pinpointsmsvoicev2.model.SenderIdAndCountry]
  type SpendLimitList = List[zio.aws.pinpointsmsvoicev2.model.SpendLimit]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.pinpointsmsvoicev2.model.Tag]
}
