package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.{Id, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RollbackTransactionRequest(
    resourceArn: Arn,
    secretArn: Arn,
    transactionId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.RollbackTransactionRequest = {
    import RollbackTransactionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.RollbackTransactionRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .secretArn(Arn.unwrap(secretArn): java.lang.String)
      .transactionId(Id.unwrap(transactionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.RollbackTransactionRequest.ReadOnly =
    zio.aws.rdsdata.model.RollbackTransactionRequest.wrap(buildAwsValue())
}
object RollbackTransactionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.RollbackTransactionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.RollbackTransactionRequest =
      zio.aws.rdsdata.model
        .RollbackTransactionRequest(resourceArn, secretArn, transactionId)
    def resourceArn: Arn
    def secretArn: Arn
    def transactionId: Id
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getSecretArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(secretArn)
    def getTransactionId: ZIO[Any, Nothing, Id] = ZIO.succeed(transactionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.RollbackTransactionRequest
  ) extends zio.aws.rdsdata.model.RollbackTransactionRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.rdsdata.model.primitives.Arn(impl.resourceArn())
    override val secretArn: Arn =
      zio.aws.rdsdata.model.primitives.Arn(impl.secretArn())
    override val transactionId: Id =
      zio.aws.rdsdata.model.primitives.Id(impl.transactionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.RollbackTransactionRequest
  ): zio.aws.rdsdata.model.RollbackTransactionRequest.ReadOnly = new Wrapper(
    impl
  )
}
