package zio.aws.rdsdata
import zio.aws.rdsdata.model.primitives.{BoxedLong, BoxedDouble, BoxedBoolean}
import zio.prelude.Subtype
import zio.Chunk
import zio.aws.rdsdata.model.primitives.Blob.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Arn extends Subtype[String]
    type Arn = zio.aws.rdsdata.model.primitives.Arn.Type
    object Blob extends Subtype[Chunk[Byte]]
    type Blob = zio.aws.rdsdata.model.primitives.Blob.Type
    type BoxedBoolean = Boolean
    type BoxedDouble = Double
    type BoxedLong = Long
    object DbName extends Subtype[String]
    type DbName = zio.aws.rdsdata.model.primitives.DbName.Type
    object Id extends Subtype[String]
    type Id = zio.aws.rdsdata.model.primitives.Id.Type
    type Integer = Int
    object ParameterName extends Subtype[String]
    type ParameterName = zio.aws.rdsdata.model.primitives.ParameterName.Type
    object RecordsUpdated extends Subtype[Long]
    type RecordsUpdated = zio.aws.rdsdata.model.primitives.RecordsUpdated.Type
    object SqlStatement extends Subtype[String]
    type SqlStatement = zio.aws.rdsdata.model.primitives.SqlStatement.Type
    object TransactionStatus extends Subtype[String]
    type TransactionStatus =
      zio.aws.rdsdata.model.primitives.TransactionStatus.Type
  }
  type ArrayOfArray = List[zio.aws.rdsdata.model.ArrayValue]
  type BooleanArray = List[BoxedBoolean]
  type DoubleArray = List[BoxedDouble]
  type FieldList = List[zio.aws.rdsdata.model.Field]
  type LongArray = List[BoxedLong]
  type Metadata = List[zio.aws.rdsdata.model.ColumnMetadata]
  type SqlParameterSets = List[Iterable[zio.aws.rdsdata.model.SqlParameter]]
  type SqlParametersList = List[zio.aws.rdsdata.model.SqlParameter]
  type SqlRecords = List[Iterable[zio.aws.rdsdata.model.Field]]
  type StringArray = List[String]
  type UpdateResults = List[zio.aws.rdsdata.model.UpdateResult]
}
