package zio.aws.s3
import zio.aws.s3.model.PutObjectLockConfigurationResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.s3.model.{
  PutBucketWebsiteRequest,
  PutBucketPolicyRequest,
  RestoreObjectRequest,
  DeleteObjectTaggingRequest,
  ListObjectsRequest,
  GetBucketLoggingRequest,
  PutObjectRetentionRequest,
  GetBucketVersioningRequest,
  GetBucketEncryptionRequest,
  GetBucketNotificationConfigurationRequest,
  DeleteBucketReplicationRequest,
  PutBucketLifecycleConfigurationRequest,
  DeleteBucketIntelligentTieringConfigurationRequest,
  HeadBucketRequest,
  GetBucketAclRequest,
  DeleteObjectsRequest,
  PutBucketVersioningRequest,
  PutBucketAnalyticsConfigurationRequest,
  GetBucketReplicationRequest,
  GetBucketPolicyRequest,
  WriteGetObjectResponseRequest,
  SelectObjectContentRequest,
  PutBucketNotificationConfigurationRequest,
  DeleteBucketTaggingRequest,
  PutBucketEncryptionRequest,
  PutBucketAclRequest,
  GetBucketOwnershipControlsRequest,
  DeleteBucketAnalyticsConfigurationRequest,
  PutBucketInventoryConfigurationRequest,
  GetBucketLocationRequest,
  ListBucketIntelligentTieringConfigurationsRequest,
  GetObjectRetentionRequest,
  GetBucketCorsRequest,
  PutObjectTaggingRequest,
  AbortMultipartUploadRequest,
  UploadPartCopyRequest,
  HeadObjectRequest,
  PutObjectRequest,
  PutPublicAccessBlockRequest,
  GetBucketTaggingRequest,
  GetBucketWebsiteRequest,
  GetBucketInventoryConfigurationRequest,
  DeleteBucketLifecycleRequest,
  ListBucketMetricsConfigurationsRequest,
  PutBucketReplicationRequest,
  ListMultipartUploadsRequest,
  GetPublicAccessBlockRequest,
  DeletePublicAccessBlockRequest,
  PutBucketCorsRequest,
  UploadPartRequest,
  ListBucketInventoryConfigurationsRequest,
  GetBucketIntelligentTieringConfigurationRequest,
  GetBucketPolicyStatusRequest,
  PutBucketIntelligentTieringConfigurationRequest,
  GetBucketLifecycleConfigurationRequest,
  DeleteBucketInventoryConfigurationRequest,
  GetBucketRequestPaymentRequest,
  PutBucketAccelerateConfigurationRequest,
  DeleteBucketRequest,
  PutBucketOwnershipControlsRequest,
  PutObjectLegalHoldRequest,
  DeleteBucketWebsiteRequest,
  GetObjectRequest,
  GetObjectTaggingRequest,
  CopyObjectRequest,
  DeleteBucketEncryptionRequest,
  CompleteMultipartUploadRequest,
  DeleteBucketOwnershipControlsRequest,
  PutObjectAclRequest,
  CreateBucketRequest,
  ListObjectVersionsRequest,
  GetBucketMetricsConfigurationRequest,
  ListBucketAnalyticsConfigurationsRequest,
  DeleteBucketCorsRequest,
  GetObjectAclRequest,
  DeleteBucketPolicyRequest,
  GetObjectLegalHoldRequest,
  ListPartsRequest,
  CreateMultipartUploadRequest,
  PutBucketTaggingRequest,
  GetObjectTorrentRequest,
  PutObjectLockConfigurationRequest,
  DeleteObjectRequest,
  GetObjectAttributesRequest,
  GetObjectLockConfigurationRequest,
  GetBucketAnalyticsConfigurationRequest,
  PutBucketLoggingRequest,
  GetBucketAccelerateConfigurationRequest,
  PutBucketMetricsConfigurationRequest,
  PutBucketRequestPaymentRequest,
  DeleteBucketMetricsConfigurationRequest,
  ListObjectsV2Request
}
import software.amazon.awssdk.services.s3.S3AsyncClient
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object S3Mock extends Mock[S3] {
  object UploadPart
      extends Effect[
        Tuple2[UploadPartRequest, ZStream[Any, AwsError, Byte]],
        AwsError,
        zio.aws.s3.model.UploadPartResponse.ReadOnly
      ]
  object CreateMultipartUpload
      extends Effect[
        CreateMultipartUploadRequest,
        AwsError,
        zio.aws.s3.model.CreateMultipartUploadResponse.ReadOnly
      ]
  object PutBucketPolicy extends Effect[PutBucketPolicyRequest, AwsError, Unit]
  object GetBucketPolicy
      extends Effect[
        GetBucketPolicyRequest,
        AwsError,
        zio.aws.s3.model.GetBucketPolicyResponse.ReadOnly
      ]
  object PutBucketIntelligentTieringConfiguration
      extends Effect[
        PutBucketIntelligentTieringConfigurationRequest,
        AwsError,
        Unit
      ]
  object RestoreObject
      extends Effect[
        RestoreObjectRequest,
        AwsError,
        zio.aws.s3.model.RestoreObjectResponse.ReadOnly
      ]
  object DeleteBucketWebsite
      extends Effect[DeleteBucketWebsiteRequest, AwsError, Unit]
  object PutBucketLifecycleConfiguration
      extends Effect[PutBucketLifecycleConfigurationRequest, AwsError, Unit]
  object ListObjectVersions
      extends Stream[
        ListObjectVersionsRequest,
        AwsError,
        zio.aws.s3.model.ObjectVersion.ReadOnly
      ]
  object ListObjectVersionsPaginated
      extends Effect[
        ListObjectVersionsRequest,
        AwsError,
        zio.aws.s3.model.ListObjectVersionsResponse.ReadOnly
      ]
  object PutBucketLogging
      extends Effect[PutBucketLoggingRequest, AwsError, Unit]
  object DeleteBucketPolicy
      extends Effect[DeleteBucketPolicyRequest, AwsError, Unit]
  object PutBucketAnalyticsConfiguration
      extends Effect[PutBucketAnalyticsConfigurationRequest, AwsError, Unit]
  object DeleteBucketInventoryConfiguration
      extends Effect[DeleteBucketInventoryConfigurationRequest, AwsError, Unit]
  object GetBucketAnalyticsConfiguration
      extends Effect[
        GetBucketAnalyticsConfigurationRequest,
        AwsError,
        zio.aws.s3.model.GetBucketAnalyticsConfigurationResponse.ReadOnly
      ]
  object PutObjectAcl
      extends Effect[
        PutObjectAclRequest,
        AwsError,
        zio.aws.s3.model.PutObjectAclResponse.ReadOnly
      ]
  object ListBucketAnalyticsConfigurations
      extends Effect[
        ListBucketAnalyticsConfigurationsRequest,
        AwsError,
        zio.aws.s3.model.ListBucketAnalyticsConfigurationsResponse.ReadOnly
      ]
  object DeleteBucketLifecycle
      extends Effect[DeleteBucketLifecycleRequest, AwsError, Unit]
  object GetObjectAcl
      extends Effect[
        GetObjectAclRequest,
        AwsError,
        zio.aws.s3.model.GetObjectAclResponse.ReadOnly
      ]
  object ListBucketInventoryConfigurations
      extends Effect[
        ListBucketInventoryConfigurationsRequest,
        AwsError,
        zio.aws.s3.model.ListBucketInventoryConfigurationsResponse.ReadOnly
      ]
  object ListMultipartUploads
      extends Stream[
        ListMultipartUploadsRequest,
        AwsError,
        zio.aws.s3.model.MultipartUpload.ReadOnly
      ]
  object ListMultipartUploadsPaginated
      extends Effect[
        ListMultipartUploadsRequest,
        AwsError,
        zio.aws.s3.model.ListMultipartUploadsResponse.ReadOnly
      ]
  object GetBucketLifecycleConfiguration
      extends Effect[
        GetBucketLifecycleConfigurationRequest,
        AwsError,
        zio.aws.s3.model.GetBucketLifecycleConfigurationResponse.ReadOnly
      ]
  object GetBucketEncryption
      extends Effect[
        GetBucketEncryptionRequest,
        AwsError,
        zio.aws.s3.model.GetBucketEncryptionResponse.ReadOnly
      ]
  object WriteGetObjectResponse
      extends Effect[
        Tuple2[WriteGetObjectResponseRequest, ZStream[Any, AwsError, Byte]],
        AwsError,
        Unit
      ]
  object GetBucketCors
      extends Effect[
        GetBucketCorsRequest,
        AwsError,
        zio.aws.s3.model.GetBucketCorsResponse.ReadOnly
      ]
  object GetObjectRetention
      extends Effect[
        GetObjectRetentionRequest,
        AwsError,
        zio.aws.s3.model.GetObjectRetentionResponse.ReadOnly
      ]
  object GetBucketLogging
      extends Effect[
        GetBucketLoggingRequest,
        AwsError,
        zio.aws.s3.model.GetBucketLoggingResponse.ReadOnly
      ]
  object ListParts
      extends Stream[ListPartsRequest, AwsError, zio.aws.s3.model.Part.ReadOnly]
  object ListPartsPaginated
      extends Effect[
        ListPartsRequest,
        AwsError,
        zio.aws.s3.model.ListPartsResponse.ReadOnly
      ]
  object GetObjectAttributes
      extends Effect[
        GetObjectAttributesRequest,
        AwsError,
        zio.aws.s3.model.GetObjectAttributesResponse.ReadOnly
      ]
  object ListBucketIntelligentTieringConfigurations
      extends Effect[
        ListBucketIntelligentTieringConfigurationsRequest,
        AwsError,
        zio.aws.s3.model.ListBucketIntelligentTieringConfigurationsResponse.ReadOnly
      ]
  object ListBucketMetricsConfigurations
      extends Effect[
        ListBucketMetricsConfigurationsRequest,
        AwsError,
        zio.aws.s3.model.ListBucketMetricsConfigurationsResponse.ReadOnly
      ]
  object PutBucketMetricsConfiguration
      extends Effect[PutBucketMetricsConfigurationRequest, AwsError, Unit]
  object DeleteBucketAnalyticsConfiguration
      extends Effect[DeleteBucketAnalyticsConfigurationRequest, AwsError, Unit]
  object DeleteBucketReplication
      extends Effect[DeleteBucketReplicationRequest, AwsError, Unit]
  object UploadPartCopy
      extends Effect[
        UploadPartCopyRequest,
        AwsError,
        zio.aws.s3.model.UploadPartCopyResponse.ReadOnly
      ]
  object GetObjectLegalHold
      extends Effect[
        GetObjectLegalHoldRequest,
        AwsError,
        zio.aws.s3.model.GetObjectLegalHoldResponse.ReadOnly
      ]
  object GetBucketRequestPayment
      extends Effect[
        GetBucketRequestPaymentRequest,
        AwsError,
        zio.aws.s3.model.GetBucketRequestPaymentResponse.ReadOnly
      ]
  object GetBucketMetricsConfiguration
      extends Effect[
        GetBucketMetricsConfigurationRequest,
        AwsError,
        zio.aws.s3.model.GetBucketMetricsConfigurationResponse.ReadOnly
      ]
  object CopyObject
      extends Effect[
        CopyObjectRequest,
        AwsError,
        zio.aws.s3.model.CopyObjectResponse.ReadOnly
      ]
  object PutBucketWebsite
      extends Effect[PutBucketWebsiteRequest, AwsError, Unit]
  object GetBucketAccelerateConfiguration
      extends Effect[
        GetBucketAccelerateConfigurationRequest,
        AwsError,
        zio.aws.s3.model.GetBucketAccelerateConfigurationResponse.ReadOnly
      ]
  object HeadBucket extends Effect[HeadBucketRequest, AwsError, Unit]
  object DeleteObject
      extends Effect[
        DeleteObjectRequest,
        AwsError,
        zio.aws.s3.model.DeleteObjectResponse.ReadOnly
      ]
  object GetBucketOwnershipControls
      extends Effect[
        GetBucketOwnershipControlsRequest,
        AwsError,
        zio.aws.s3.model.GetBucketOwnershipControlsResponse.ReadOnly
      ]
  object PutBucketReplication
      extends Effect[PutBucketReplicationRequest, AwsError, Unit]
  object DeleteBucket extends Effect[DeleteBucketRequest, AwsError, Unit]
  object PutBucketNotificationConfiguration
      extends Effect[PutBucketNotificationConfigurationRequest, AwsError, Unit]
  object DeleteBucketMetricsConfiguration
      extends Effect[DeleteBucketMetricsConfigurationRequest, AwsError, Unit]
  object CreateBucket
      extends Effect[
        CreateBucketRequest,
        AwsError,
        zio.aws.s3.model.CreateBucketResponse.ReadOnly
      ]
  object ListObjects
      extends Effect[
        ListObjectsRequest,
        AwsError,
        zio.aws.s3.model.ListObjectsResponse.ReadOnly
      ]
  object ListBuckets
      extends Effect[
        Unit,
        AwsError,
        zio.aws.s3.model.ListBucketsResponse.ReadOnly
      ]
  object GetBucketTagging
      extends Effect[
        GetBucketTaggingRequest,
        AwsError,
        zio.aws.s3.model.GetBucketTaggingResponse.ReadOnly
      ]
  object PutObject
      extends Effect[
        Tuple2[PutObjectRequest, ZStream[Any, AwsError, Byte]],
        AwsError,
        zio.aws.s3.model.PutObjectResponse.ReadOnly
      ]
  object PutBucketTagging
      extends Effect[PutBucketTaggingRequest, AwsError, Unit]
  object DeleteBucketTagging
      extends Effect[DeleteBucketTaggingRequest, AwsError, Unit]
  object PutBucketEncryption
      extends Effect[PutBucketEncryptionRequest, AwsError, Unit]
  object PutBucketRequestPayment
      extends Effect[PutBucketRequestPaymentRequest, AwsError, Unit]
  object GetObject
      extends Effect[GetObjectRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.s3.model.GetObjectResponse.ReadOnly,
        Byte
      ]]
  object PutObjectTagging
      extends Effect[
        PutObjectTaggingRequest,
        AwsError,
        zio.aws.s3.model.PutObjectTaggingResponse.ReadOnly
      ]
  object DeleteBucketCors
      extends Effect[DeleteBucketCorsRequest, AwsError, Unit]
  object PutPublicAccessBlock
      extends Effect[PutPublicAccessBlockRequest, AwsError, Unit]
  object GetObjectTorrent
      extends Effect[GetObjectTorrentRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.s3.model.GetObjectTorrentResponse.ReadOnly,
        Byte
      ]]
  object GetBucketInventoryConfiguration
      extends Effect[
        GetBucketInventoryConfigurationRequest,
        AwsError,
        zio.aws.s3.model.GetBucketInventoryConfigurationResponse.ReadOnly
      ]
  object GetBucketVersioning
      extends Effect[
        GetBucketVersioningRequest,
        AwsError,
        zio.aws.s3.model.GetBucketVersioningResponse.ReadOnly
      ]
  object PutBucketOwnershipControls
      extends Effect[PutBucketOwnershipControlsRequest, AwsError, Unit]
  object HeadObject
      extends Effect[
        HeadObjectRequest,
        AwsError,
        zio.aws.s3.model.HeadObjectResponse.ReadOnly
      ]
  object SelectObjectContent
      extends Stream[
        SelectObjectContentRequest,
        AwsError,
        zio.aws.s3.model.RecordsEvent.ReadOnly
      ]
  object GetBucketWebsite
      extends Effect[
        GetBucketWebsiteRequest,
        AwsError,
        zio.aws.s3.model.GetBucketWebsiteResponse.ReadOnly
      ]
  object DeleteBucketIntelligentTieringConfiguration
      extends Effect[
        DeleteBucketIntelligentTieringConfigurationRequest,
        AwsError,
        Unit
      ]
  object PutBucketInventoryConfiguration
      extends Effect[PutBucketInventoryConfigurationRequest, AwsError, Unit]
  object GetBucketIntelligentTieringConfiguration
      extends Effect[
        GetBucketIntelligentTieringConfigurationRequest,
        AwsError,
        zio.aws.s3.model.GetBucketIntelligentTieringConfigurationResponse.ReadOnly
      ]
  object GetBucketAcl
      extends Effect[
        GetBucketAclRequest,
        AwsError,
        zio.aws.s3.model.GetBucketAclResponse.ReadOnly
      ]
  object ListObjectsV2
      extends Stream[
        ListObjectsV2Request,
        AwsError,
        zio.aws.s3.model.S3Object.ReadOnly
      ]
  object ListObjectsV2Paginated
      extends Effect[
        ListObjectsV2Request,
        AwsError,
        zio.aws.s3.model.ListObjectsV2Response.ReadOnly
      ]
  object PutBucketVersioning
      extends Effect[PutBucketVersioningRequest, AwsError, Unit]
  object PutBucketAcl extends Effect[PutBucketAclRequest, AwsError, Unit]
  object GetBucketReplication
      extends Effect[
        GetBucketReplicationRequest,
        AwsError,
        zio.aws.s3.model.GetBucketReplicationResponse.ReadOnly
      ]
  object GetPublicAccessBlock
      extends Effect[
        GetPublicAccessBlockRequest,
        AwsError,
        zio.aws.s3.model.GetPublicAccessBlockResponse.ReadOnly
      ]
  object PutObjectLegalHold
      extends Effect[
        PutObjectLegalHoldRequest,
        AwsError,
        zio.aws.s3.model.PutObjectLegalHoldResponse.ReadOnly
      ]
  object GetObjectLockConfiguration
      extends Effect[
        GetObjectLockConfigurationRequest,
        AwsError,
        zio.aws.s3.model.GetObjectLockConfigurationResponse.ReadOnly
      ]
  object GetBucketLocation
      extends Effect[
        GetBucketLocationRequest,
        AwsError,
        zio.aws.s3.model.GetBucketLocationResponse.ReadOnly
      ]
  object DeleteObjects
      extends Effect[
        DeleteObjectsRequest,
        AwsError,
        zio.aws.s3.model.DeleteObjectsResponse.ReadOnly
      ]
  object AbortMultipartUpload
      extends Effect[
        AbortMultipartUploadRequest,
        AwsError,
        zio.aws.s3.model.AbortMultipartUploadResponse.ReadOnly
      ]
  object GetBucketPolicyStatus
      extends Effect[
        GetBucketPolicyStatusRequest,
        AwsError,
        zio.aws.s3.model.GetBucketPolicyStatusResponse.ReadOnly
      ]
  object DeleteBucketOwnershipControls
      extends Effect[DeleteBucketOwnershipControlsRequest, AwsError, Unit]
  object PutObjectRetention
      extends Effect[
        PutObjectRetentionRequest,
        AwsError,
        zio.aws.s3.model.PutObjectRetentionResponse.ReadOnly
      ]
  object PutBucketCors extends Effect[PutBucketCorsRequest, AwsError, Unit]
  object DeleteObjectTagging
      extends Effect[
        DeleteObjectTaggingRequest,
        AwsError,
        zio.aws.s3.model.DeleteObjectTaggingResponse.ReadOnly
      ]
  object DeletePublicAccessBlock
      extends Effect[DeletePublicAccessBlockRequest, AwsError, Unit]
  object DeleteBucketEncryption
      extends Effect[DeleteBucketEncryptionRequest, AwsError, Unit]
  object CompleteMultipartUpload
      extends Effect[
        CompleteMultipartUploadRequest,
        AwsError,
        zio.aws.s3.model.CompleteMultipartUploadResponse.ReadOnly
      ]
  object GetObjectTagging
      extends Effect[
        GetObjectTaggingRequest,
        AwsError,
        zio.aws.s3.model.GetObjectTaggingResponse.ReadOnly
      ]
  object PutObjectLockConfiguration
      extends Effect[PutObjectLockConfigurationRequest, AwsError, ReadOnly]
  object PutBucketAccelerateConfiguration
      extends Effect[PutBucketAccelerateConfigurationRequest, AwsError, Unit]
  object GetBucketNotificationConfiguration
      extends Effect[
        GetBucketNotificationConfigurationRequest,
        AwsError,
        zio.aws.s3.model.GetBucketNotificationConfigurationResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, S3] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, S3] { rts =>
        zio.ZIO.succeed {
          new S3 {
            val api: S3AsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): S3 = this
            def uploadPart(
                request: UploadPartRequest,
                body: ZStream[Any, AwsError, Byte]
            ): IO[AwsError, zio.aws.s3.model.UploadPartResponse.ReadOnly] =
              proxy(UploadPart, request, body)
            def createMultipartUpload(
                request: CreateMultipartUploadRequest
            ): IO[
              AwsError,
              zio.aws.s3.model.CreateMultipartUploadResponse.ReadOnly
            ] = proxy(CreateMultipartUpload, request)
            def putBucketPolicy(
                request: PutBucketPolicyRequest
            ): IO[AwsError, Unit] = proxy(PutBucketPolicy, request)
            def getBucketPolicy(
                request: GetBucketPolicyRequest
            ): IO[AwsError, zio.aws.s3.model.GetBucketPolicyResponse.ReadOnly] =
              proxy(GetBucketPolicy, request)
            def putBucketIntelligentTieringConfiguration(
                request: PutBucketIntelligentTieringConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(PutBucketIntelligentTieringConfiguration, request)
            def restoreObject(
                request: RestoreObjectRequest
            ): IO[AwsError, zio.aws.s3.model.RestoreObjectResponse.ReadOnly] =
              proxy(RestoreObject, request)
            def deleteBucketWebsite(
                request: DeleteBucketWebsiteRequest
            ): IO[AwsError, Unit] = proxy(DeleteBucketWebsite, request)
            def putBucketLifecycleConfiguration(
                request: PutBucketLifecycleConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(PutBucketLifecycleConfiguration, request)
            def listObjectVersions(
                request: ListObjectVersionsRequest
            ): ZStream[Any, AwsError, zio.aws.s3.model.ObjectVersion.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListObjectVersions, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listObjectVersionsPaginated(
                request: ListObjectVersionsRequest
            ): IO[
              AwsError,
              zio.aws.s3.model.ListObjectVersionsResponse.ReadOnly
            ] = proxy(ListObjectVersionsPaginated, request)
            def putBucketLogging(
                request: PutBucketLoggingRequest
            ): IO[AwsError, Unit] = proxy(PutBucketLogging, request)
            def deleteBucketPolicy(
                request: DeleteBucketPolicyRequest
            ): IO[AwsError, Unit] = proxy(DeleteBucketPolicy, request)
            def putBucketAnalyticsConfiguration(
                request: PutBucketAnalyticsConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(PutBucketAnalyticsConfiguration, request)
            def deleteBucketInventoryConfiguration(
                request: DeleteBucketInventoryConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteBucketInventoryConfiguration, request)
            def getBucketAnalyticsConfiguration(
                request: GetBucketAnalyticsConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.s3.model.GetBucketAnalyticsConfigurationResponse.ReadOnly
            ] = proxy(GetBucketAnalyticsConfiguration, request)
            def putObjectAcl(
                request: PutObjectAclRequest
            ): IO[AwsError, zio.aws.s3.model.PutObjectAclResponse.ReadOnly] =
              proxy(PutObjectAcl, request)
            def listBucketAnalyticsConfigurations(
                request: ListBucketAnalyticsConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.s3.model.ListBucketAnalyticsConfigurationsResponse.ReadOnly
            ] = proxy(ListBucketAnalyticsConfigurations, request)
            def deleteBucketLifecycle(
                request: DeleteBucketLifecycleRequest
            ): IO[AwsError, Unit] = proxy(DeleteBucketLifecycle, request)
            def getObjectAcl(
                request: GetObjectAclRequest
            ): IO[AwsError, zio.aws.s3.model.GetObjectAclResponse.ReadOnly] =
              proxy(GetObjectAcl, request)
            def listBucketInventoryConfigurations(
                request: ListBucketInventoryConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.s3.model.ListBucketInventoryConfigurationsResponse.ReadOnly
            ] = proxy(ListBucketInventoryConfigurations, request)
            def listMultipartUploads(
                request: ListMultipartUploadsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.s3.model.MultipartUpload.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMultipartUploads, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMultipartUploadsPaginated(
                request: ListMultipartUploadsRequest
            ): IO[
              AwsError,
              zio.aws.s3.model.ListMultipartUploadsResponse.ReadOnly
            ] = proxy(ListMultipartUploadsPaginated, request)
            def getBucketLifecycleConfiguration(
                request: GetBucketLifecycleConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.s3.model.GetBucketLifecycleConfigurationResponse.ReadOnly
            ] = proxy(GetBucketLifecycleConfiguration, request)
            def getBucketEncryption(request: GetBucketEncryptionRequest): IO[
              AwsError,
              zio.aws.s3.model.GetBucketEncryptionResponse.ReadOnly
            ] = proxy(GetBucketEncryption, request)
            def writeGetObjectResponse(
                request: WriteGetObjectResponseRequest,
                body: ZStream[Any, AwsError, Byte]
            ): IO[AwsError, Unit] = proxy(WriteGetObjectResponse, request, body)
            def getBucketCors(
                request: GetBucketCorsRequest
            ): IO[AwsError, zio.aws.s3.model.GetBucketCorsResponse.ReadOnly] =
              proxy(GetBucketCors, request)
            def getObjectRetention(request: GetObjectRetentionRequest): IO[
              AwsError,
              zio.aws.s3.model.GetObjectRetentionResponse.ReadOnly
            ] = proxy(GetObjectRetention, request)
            def getBucketLogging(request: GetBucketLoggingRequest): IO[
              AwsError,
              zio.aws.s3.model.GetBucketLoggingResponse.ReadOnly
            ] = proxy(GetBucketLogging, request)
            def listParts(
                request: ListPartsRequest
            ): ZStream[Any, AwsError, zio.aws.s3.model.Part.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListParts, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listPartsPaginated(
                request: ListPartsRequest
            ): IO[AwsError, zio.aws.s3.model.ListPartsResponse.ReadOnly] =
              proxy(ListPartsPaginated, request)
            def getObjectAttributes(request: GetObjectAttributesRequest): IO[
              AwsError,
              zio.aws.s3.model.GetObjectAttributesResponse.ReadOnly
            ] = proxy(GetObjectAttributes, request)
            def listBucketIntelligentTieringConfigurations(
                request: ListBucketIntelligentTieringConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.s3.model.ListBucketIntelligentTieringConfigurationsResponse.ReadOnly
            ] = proxy(ListBucketIntelligentTieringConfigurations, request)
            def listBucketMetricsConfigurations(
                request: ListBucketMetricsConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.s3.model.ListBucketMetricsConfigurationsResponse.ReadOnly
            ] = proxy(ListBucketMetricsConfigurations, request)
            def putBucketMetricsConfiguration(
                request: PutBucketMetricsConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(PutBucketMetricsConfiguration, request)
            def deleteBucketAnalyticsConfiguration(
                request: DeleteBucketAnalyticsConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteBucketAnalyticsConfiguration, request)
            def deleteBucketReplication(
                request: DeleteBucketReplicationRequest
            ): IO[AwsError, Unit] = proxy(DeleteBucketReplication, request)
            def uploadPartCopy(
                request: UploadPartCopyRequest
            ): IO[AwsError, zio.aws.s3.model.UploadPartCopyResponse.ReadOnly] =
              proxy(UploadPartCopy, request)
            def getObjectLegalHold(request: GetObjectLegalHoldRequest): IO[
              AwsError,
              zio.aws.s3.model.GetObjectLegalHoldResponse.ReadOnly
            ] = proxy(GetObjectLegalHold, request)
            def getBucketRequestPayment(
                request: GetBucketRequestPaymentRequest
            ): IO[
              AwsError,
              zio.aws.s3.model.GetBucketRequestPaymentResponse.ReadOnly
            ] = proxy(GetBucketRequestPayment, request)
            def getBucketMetricsConfiguration(
                request: GetBucketMetricsConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.s3.model.GetBucketMetricsConfigurationResponse.ReadOnly
            ] = proxy(GetBucketMetricsConfiguration, request)
            def copyObject(
                request: CopyObjectRequest
            ): IO[AwsError, zio.aws.s3.model.CopyObjectResponse.ReadOnly] =
              proxy(CopyObject, request)
            def putBucketWebsite(
                request: PutBucketWebsiteRequest
            ): IO[AwsError, Unit] = proxy(PutBucketWebsite, request)
            def getBucketAccelerateConfiguration(
                request: GetBucketAccelerateConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.s3.model.GetBucketAccelerateConfigurationResponse.ReadOnly
            ] = proxy(GetBucketAccelerateConfiguration, request)
            def headBucket(request: HeadBucketRequest): IO[AwsError, Unit] =
              proxy(HeadBucket, request)
            def deleteObject(
                request: DeleteObjectRequest
            ): IO[AwsError, zio.aws.s3.model.DeleteObjectResponse.ReadOnly] =
              proxy(DeleteObject, request)
            def getBucketOwnershipControls(
                request: GetBucketOwnershipControlsRequest
            ): IO[
              AwsError,
              zio.aws.s3.model.GetBucketOwnershipControlsResponse.ReadOnly
            ] = proxy(GetBucketOwnershipControls, request)
            def putBucketReplication(
                request: PutBucketReplicationRequest
            ): IO[AwsError, Unit] = proxy(PutBucketReplication, request)
            def deleteBucket(request: DeleteBucketRequest): IO[AwsError, Unit] =
              proxy(DeleteBucket, request)
            def putBucketNotificationConfiguration(
                request: PutBucketNotificationConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(PutBucketNotificationConfiguration, request)
            def deleteBucketMetricsConfiguration(
                request: DeleteBucketMetricsConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteBucketMetricsConfiguration, request)
            def createBucket(
                request: CreateBucketRequest
            ): IO[AwsError, zio.aws.s3.model.CreateBucketResponse.ReadOnly] =
              proxy(CreateBucket, request)
            def listObjects(
                request: ListObjectsRequest
            ): IO[AwsError, zio.aws.s3.model.ListObjectsResponse.ReadOnly] =
              proxy(ListObjects, request)
            def listBuckets()
                : IO[AwsError, zio.aws.s3.model.ListBucketsResponse.ReadOnly] =
              proxy(ListBuckets)
            def getBucketTagging(request: GetBucketTaggingRequest): IO[
              AwsError,
              zio.aws.s3.model.GetBucketTaggingResponse.ReadOnly
            ] = proxy(GetBucketTagging, request)
            def putObject(
                request: PutObjectRequest,
                body: ZStream[Any, AwsError, Byte]
            ): IO[AwsError, zio.aws.s3.model.PutObjectResponse.ReadOnly] =
              proxy(PutObject, request, body)
            def putBucketTagging(
                request: PutBucketTaggingRequest
            ): IO[AwsError, Unit] = proxy(PutBucketTagging, request)
            def deleteBucketTagging(
                request: DeleteBucketTaggingRequest
            ): IO[AwsError, Unit] = proxy(DeleteBucketTagging, request)
            def putBucketEncryption(
                request: PutBucketEncryptionRequest
            ): IO[AwsError, Unit] = proxy(PutBucketEncryption, request)
            def putBucketRequestPayment(
                request: PutBucketRequestPaymentRequest
            ): IO[AwsError, Unit] = proxy(PutBucketRequestPayment, request)
            def getObject(
                request: GetObjectRequest
            ): IO[AwsError, StreamingOutputResult[
              Any,
              zio.aws.s3.model.GetObjectResponse.ReadOnly,
              Byte
            ]] = proxy(GetObject, request)
            def putObjectTagging(request: PutObjectTaggingRequest): IO[
              AwsError,
              zio.aws.s3.model.PutObjectTaggingResponse.ReadOnly
            ] = proxy(PutObjectTagging, request)
            def deleteBucketCors(
                request: DeleteBucketCorsRequest
            ): IO[AwsError, Unit] = proxy(DeleteBucketCors, request)
            def putPublicAccessBlock(
                request: PutPublicAccessBlockRequest
            ): IO[AwsError, Unit] = proxy(PutPublicAccessBlock, request)
            def getObjectTorrent(
                request: GetObjectTorrentRequest
            ): IO[AwsError, StreamingOutputResult[
              Any,
              zio.aws.s3.model.GetObjectTorrentResponse.ReadOnly,
              Byte
            ]] = proxy(GetObjectTorrent, request)
            def getBucketInventoryConfiguration(
                request: GetBucketInventoryConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.s3.model.GetBucketInventoryConfigurationResponse.ReadOnly
            ] = proxy(GetBucketInventoryConfiguration, request)
            def getBucketVersioning(request: GetBucketVersioningRequest): IO[
              AwsError,
              zio.aws.s3.model.GetBucketVersioningResponse.ReadOnly
            ] = proxy(GetBucketVersioning, request)
            def putBucketOwnershipControls(
                request: PutBucketOwnershipControlsRequest
            ): IO[AwsError, Unit] = proxy(PutBucketOwnershipControls, request)
            def headObject(
                request: HeadObjectRequest
            ): IO[AwsError, zio.aws.s3.model.HeadObjectResponse.ReadOnly] =
              proxy(HeadObject, request)
            def selectObjectContent(
                request: SelectObjectContentRequest
            ): ZStream[Any, AwsError, zio.aws.s3.model.RecordsEvent.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(SelectObjectContent, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def getBucketWebsite(request: GetBucketWebsiteRequest): IO[
              AwsError,
              zio.aws.s3.model.GetBucketWebsiteResponse.ReadOnly
            ] = proxy(GetBucketWebsite, request)
            def deleteBucketIntelligentTieringConfiguration(
                request: DeleteBucketIntelligentTieringConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteBucketIntelligentTieringConfiguration, request)
            def putBucketInventoryConfiguration(
                request: PutBucketInventoryConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(PutBucketInventoryConfiguration, request)
            def getBucketIntelligentTieringConfiguration(
                request: GetBucketIntelligentTieringConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.s3.model.GetBucketIntelligentTieringConfigurationResponse.ReadOnly
            ] = proxy(GetBucketIntelligentTieringConfiguration, request)
            def getBucketAcl(
                request: GetBucketAclRequest
            ): IO[AwsError, zio.aws.s3.model.GetBucketAclResponse.ReadOnly] =
              proxy(GetBucketAcl, request)
            def listObjectsV2(
                request: ListObjectsV2Request
            ): ZStream[Any, AwsError, zio.aws.s3.model.S3Object.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListObjectsV2, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listObjectsV2Paginated(
                request: ListObjectsV2Request
            ): IO[AwsError, zio.aws.s3.model.ListObjectsV2Response.ReadOnly] =
              proxy(ListObjectsV2Paginated, request)
            def putBucketVersioning(
                request: PutBucketVersioningRequest
            ): IO[AwsError, Unit] = proxy(PutBucketVersioning, request)
            def putBucketAcl(request: PutBucketAclRequest): IO[AwsError, Unit] =
              proxy(PutBucketAcl, request)
            def getBucketReplication(request: GetBucketReplicationRequest): IO[
              AwsError,
              zio.aws.s3.model.GetBucketReplicationResponse.ReadOnly
            ] = proxy(GetBucketReplication, request)
            def getPublicAccessBlock(request: GetPublicAccessBlockRequest): IO[
              AwsError,
              zio.aws.s3.model.GetPublicAccessBlockResponse.ReadOnly
            ] = proxy(GetPublicAccessBlock, request)
            def putObjectLegalHold(request: PutObjectLegalHoldRequest): IO[
              AwsError,
              zio.aws.s3.model.PutObjectLegalHoldResponse.ReadOnly
            ] = proxy(PutObjectLegalHold, request)
            def getObjectLockConfiguration(
                request: GetObjectLockConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.s3.model.GetObjectLockConfigurationResponse.ReadOnly
            ] = proxy(GetObjectLockConfiguration, request)
            def getBucketLocation(request: GetBucketLocationRequest): IO[
              AwsError,
              zio.aws.s3.model.GetBucketLocationResponse.ReadOnly
            ] = proxy(GetBucketLocation, request)
            def deleteObjects(
                request: DeleteObjectsRequest
            ): IO[AwsError, zio.aws.s3.model.DeleteObjectsResponse.ReadOnly] =
              proxy(DeleteObjects, request)
            def abortMultipartUpload(request: AbortMultipartUploadRequest): IO[
              AwsError,
              zio.aws.s3.model.AbortMultipartUploadResponse.ReadOnly
            ] = proxy(AbortMultipartUpload, request)
            def getBucketPolicyStatus(
                request: GetBucketPolicyStatusRequest
            ): IO[
              AwsError,
              zio.aws.s3.model.GetBucketPolicyStatusResponse.ReadOnly
            ] = proxy(GetBucketPolicyStatus, request)
            def deleteBucketOwnershipControls(
                request: DeleteBucketOwnershipControlsRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteBucketOwnershipControls, request)
            def putObjectRetention(request: PutObjectRetentionRequest): IO[
              AwsError,
              zio.aws.s3.model.PutObjectRetentionResponse.ReadOnly
            ] = proxy(PutObjectRetention, request)
            def putBucketCors(
                request: PutBucketCorsRequest
            ): IO[AwsError, Unit] = proxy(PutBucketCors, request)
            def deleteObjectTagging(request: DeleteObjectTaggingRequest): IO[
              AwsError,
              zio.aws.s3.model.DeleteObjectTaggingResponse.ReadOnly
            ] = proxy(DeleteObjectTagging, request)
            def deletePublicAccessBlock(
                request: DeletePublicAccessBlockRequest
            ): IO[AwsError, Unit] = proxy(DeletePublicAccessBlock, request)
            def deleteBucketEncryption(
                request: DeleteBucketEncryptionRequest
            ): IO[AwsError, Unit] = proxy(DeleteBucketEncryption, request)
            def completeMultipartUpload(
                request: CompleteMultipartUploadRequest
            ): IO[
              AwsError,
              zio.aws.s3.model.CompleteMultipartUploadResponse.ReadOnly
            ] = proxy(CompleteMultipartUpload, request)
            def getObjectTagging(request: GetObjectTaggingRequest): IO[
              AwsError,
              zio.aws.s3.model.GetObjectTaggingResponse.ReadOnly
            ] = proxy(GetObjectTagging, request)
            def putObjectLockConfiguration(
                request: PutObjectLockConfigurationRequest
            ): IO[AwsError, ReadOnly] =
              proxy(PutObjectLockConfiguration, request)
            def putBucketAccelerateConfiguration(
                request: PutBucketAccelerateConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(PutBucketAccelerateConfiguration, request)
            def getBucketNotificationConfiguration(
                request: GetBucketNotificationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.s3.model.GetBucketNotificationConfigurationResponse.ReadOnly
            ] = proxy(GetBucketNotificationConfiguration, request)
          }
        }
      }
    }
  }
}
