package zio.aws.s3.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.DaysAfterInitiation
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class AbortIncompleteMultipartUpload(
    daysAfterInitiation: Optional[DaysAfterInitiation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.AbortIncompleteMultipartUpload = {
    import AbortIncompleteMultipartUpload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.AbortIncompleteMultipartUpload
      .builder()
      .optionallyWith(
        daysAfterInitiation.map(value =>
          DaysAfterInitiation.unwrap(value): Integer
        )
      )(_.daysAfterInitiation)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.AbortIncompleteMultipartUpload.ReadOnly =
    zio.aws.s3.model.AbortIncompleteMultipartUpload.wrap(buildAwsValue())
}
object AbortIncompleteMultipartUpload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.AbortIncompleteMultipartUpload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.AbortIncompleteMultipartUpload =
      zio.aws.s3.model
        .AbortIncompleteMultipartUpload(daysAfterInitiation.map(value => value))
    def daysAfterInitiation: Optional[DaysAfterInitiation]
    def getDaysAfterInitiation: ZIO[Any, AwsError, DaysAfterInitiation] =
      AwsError.unwrapOptionField("daysAfterInitiation", daysAfterInitiation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.AbortIncompleteMultipartUpload
  ) extends zio.aws.s3.model.AbortIncompleteMultipartUpload.ReadOnly {
    override val daysAfterInitiation: Optional[DaysAfterInitiation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.daysAfterInitiation())
        .map(value => zio.aws.s3.model.primitives.DaysAfterInitiation(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.AbortIncompleteMultipartUpload
  ): zio.aws.s3.model.AbortIncompleteMultipartUpload.ReadOnly = new Wrapper(
    impl
  )
}
