package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AccessControlPolicy(
    grants: Optional[Iterable[zio.aws.s3.model.Grant]] = Optional.Absent,
    owner: Optional[zio.aws.s3.model.Owner] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.AccessControlPolicy = {
    import AccessControlPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.AccessControlPolicy
      .builder()
      .optionallyWith(
        grants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.grants)
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.AccessControlPolicy.ReadOnly =
    zio.aws.s3.model.AccessControlPolicy.wrap(buildAwsValue())
}
object AccessControlPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.AccessControlPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.AccessControlPolicy =
      zio.aws.s3.model.AccessControlPolicy(
        grants.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        owner.map(value => value.asEditable)
      )
    def grants: Optional[List[zio.aws.s3.model.Grant.ReadOnly]]
    def owner: Optional[zio.aws.s3.model.Owner.ReadOnly]
    def getGrants: ZIO[Any, AwsError, List[zio.aws.s3.model.Grant.ReadOnly]] =
      AwsError.unwrapOptionField("grants", grants)
    def getOwner: ZIO[Any, AwsError, zio.aws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", owner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.AccessControlPolicy
  ) extends zio.aws.s3.model.AccessControlPolicy.ReadOnly {
    override val grants: Optional[List[zio.aws.s3.model.Grant.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grants())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.Grant.wrap(item)
          }.toList
        )
    override val owner: Optional[zio.aws.s3.model.Owner.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value => zio.aws.s3.model.Owner.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.AccessControlPolicy
  ): zio.aws.s3.model.AccessControlPolicy.ReadOnly = new Wrapper(impl)
}
