package zio.aws.s3.model
import zio.aws.s3.model.primitives.AnalyticsId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AnalyticsConfiguration(
    id: AnalyticsId,
    filter: Optional[zio.aws.s3.model.AnalyticsFilter] = Optional.Absent,
    storageClassAnalysis: zio.aws.s3.model.StorageClassAnalysis
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.AnalyticsConfiguration = {
    import AnalyticsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.AnalyticsConfiguration
      .builder()
      .id(AnalyticsId.unwrap(id): java.lang.String)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .storageClassAnalysis(storageClassAnalysis.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.s3.model.AnalyticsConfiguration.ReadOnly =
    zio.aws.s3.model.AnalyticsConfiguration.wrap(buildAwsValue())
}
object AnalyticsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.AnalyticsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.AnalyticsConfiguration =
      zio.aws.s3.model.AnalyticsConfiguration(
        id,
        filter.map(value => value.asEditable),
        storageClassAnalysis.asEditable
      )
    def id: AnalyticsId
    def filter: Optional[zio.aws.s3.model.AnalyticsFilter.ReadOnly]
    def storageClassAnalysis: zio.aws.s3.model.StorageClassAnalysis.ReadOnly
    def getId: ZIO[Any, Nothing, AnalyticsId] = ZIO.succeed(id)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.s3.model.AnalyticsFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
    def getStorageClassAnalysis
        : ZIO[Any, Nothing, zio.aws.s3.model.StorageClassAnalysis.ReadOnly] =
      ZIO.succeed(storageClassAnalysis)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.AnalyticsConfiguration
  ) extends zio.aws.s3.model.AnalyticsConfiguration.ReadOnly {
    override val id: AnalyticsId =
      zio.aws.s3.model.primitives.AnalyticsId(impl.id())
    override val filter: Optional[zio.aws.s3.model.AnalyticsFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.s3.model.AnalyticsFilter.wrap(value))
    override val storageClassAnalysis
        : zio.aws.s3.model.StorageClassAnalysis.ReadOnly =
      zio.aws.s3.model.StorageClassAnalysis.wrap(impl.storageClassAnalysis())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.AnalyticsConfiguration
  ): zio.aws.s3.model.AnalyticsConfiguration.ReadOnly = new Wrapper(impl)
}
