package zio.aws.s3.model
import zio.aws.s3.model.primitives.Prefix
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AnalyticsFilter(
    prefix: Optional[Prefix] = Optional.Absent,
    tag: Optional[zio.aws.s3.model.Tag] = Optional.Absent,
    and: Optional[zio.aws.s3.model.AnalyticsAndOperator] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.AnalyticsFilter = {
    import AnalyticsFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.AnalyticsFilter
      .builder()
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(tag.map(value => value.buildAwsValue()))(_.tag)
      .optionallyWith(and.map(value => value.buildAwsValue()))(_.and)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.AnalyticsFilter.ReadOnly =
    zio.aws.s3.model.AnalyticsFilter.wrap(buildAwsValue())
}
object AnalyticsFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.AnalyticsFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.AnalyticsFilter =
      zio.aws.s3.model.AnalyticsFilter(
        prefix.map(value => value),
        tag.map(value => value.asEditable),
        and.map(value => value.asEditable)
      )
    def prefix: Optional[Prefix]
    def tag: Optional[zio.aws.s3.model.Tag.ReadOnly]
    def and: Optional[zio.aws.s3.model.AnalyticsAndOperator.ReadOnly]
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getTag: ZIO[Any, AwsError, zio.aws.s3.model.Tag.ReadOnly] =
      AwsError.unwrapOptionField("tag", tag)
    def getAnd
        : ZIO[Any, AwsError, zio.aws.s3.model.AnalyticsAndOperator.ReadOnly] =
      AwsError.unwrapOptionField("and", and)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.AnalyticsFilter
  ) extends zio.aws.s3.model.AnalyticsFilter.ReadOnly {
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val tag: Optional[zio.aws.s3.model.Tag.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tag())
        .map(value => zio.aws.s3.model.Tag.wrap(value))
    override val and: Optional[zio.aws.s3.model.AnalyticsAndOperator.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.and())
        .map(value => zio.aws.s3.model.AnalyticsAndOperator.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.AnalyticsFilter
  ): zio.aws.s3.model.AnalyticsFilter.ReadOnly = new Wrapper(impl)
}
