package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait BucketLogsPermission {
  def unwrap: software.amazon.awssdk.services.s3.model.BucketLogsPermission
}
object BucketLogsPermission {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.BucketLogsPermission
  ): zio.aws.s3.model.BucketLogsPermission = value match {
    case software.amazon.awssdk.services.s3.model.BucketLogsPermission.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.BucketLogsPermission.FULL_CONTROL =>
      val r = FULL_CONTROL
      r
    case software.amazon.awssdk.services.s3.model.BucketLogsPermission.READ =>
      val r = READ
      r
    case software.amazon.awssdk.services.s3.model.BucketLogsPermission.WRITE =>
      val r = WRITE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3.model.BucketLogsPermission {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLogsPermission =
      software.amazon.awssdk.services.s3.model.BucketLogsPermission.UNKNOWN_TO_SDK_VERSION
  }
  case object FULL_CONTROL extends zio.aws.s3.model.BucketLogsPermission {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLogsPermission =
      software.amazon.awssdk.services.s3.model.BucketLogsPermission.FULL_CONTROL
  }
  case object READ extends zio.aws.s3.model.BucketLogsPermission {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLogsPermission =
      software.amazon.awssdk.services.s3.model.BucketLogsPermission.READ
  }
  case object WRITE extends zio.aws.s3.model.BucketLogsPermission {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketLogsPermission =
      software.amazon.awssdk.services.s3.model.BucketLogsPermission.WRITE
  }
}
