package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CORSConfiguration(
    corsRules: Iterable[zio.aws.s3.model.CORSRule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CORSConfiguration = {
    import CORSConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CORSConfiguration
      .builder()
      .corsRules(corsRules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.CORSConfiguration.ReadOnly =
    zio.aws.s3.model.CORSConfiguration.wrap(buildAwsValue())
}
object CORSConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CORSConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.CORSConfiguration =
      zio.aws.s3.model.CORSConfiguration(corsRules.map { item =>
        item.asEditable
      })
    def corsRules: List[zio.aws.s3.model.CORSRule.ReadOnly]
    def getCorsRules
        : ZIO[Any, Nothing, List[zio.aws.s3.model.CORSRule.ReadOnly]] =
      ZIO.succeed(corsRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CORSConfiguration
  ) extends zio.aws.s3.model.CORSConfiguration.ReadOnly {
    override val corsRules: List[zio.aws.s3.model.CORSRule.ReadOnly] = impl
      .corsRules()
      .asScala
      .map { item =>
        zio.aws.s3.model.CORSRule.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CORSConfiguration
  ): zio.aws.s3.model.CORSConfiguration.ReadOnly = new Wrapper(impl)
}
