package zio.aws.s3.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  AllowedOrigin,
  AllowedMethod,
  AllowedHeader,
  MaxAgeSeconds,
  ExposeHeader,
  ID
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CORSRule(
    id: Optional[ID] = Optional.Absent,
    allowedHeaders: Optional[Iterable[AllowedHeader]] = Optional.Absent,
    allowedMethods: Iterable[AllowedMethod],
    allowedOrigins: Iterable[AllowedOrigin],
    exposeHeaders: Optional[Iterable[ExposeHeader]] = Optional.Absent,
    maxAgeSeconds: Optional[MaxAgeSeconds] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.CORSRule = {
    import CORSRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CORSRule
      .builder()
      .optionallyWith(id.map(value => ID.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        allowedHeaders.map(value =>
          value.map { item =>
            AllowedHeader.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowedHeaders)
      .allowedMethods(allowedMethods.map { item =>
        AllowedMethod.unwrap(item): java.lang.String
      }.asJavaCollection)
      .allowedOrigins(allowedOrigins.map { item =>
        AllowedOrigin.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        exposeHeaders.map(value =>
          value.map { item =>
            ExposeHeader.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.exposeHeaders)
      .optionallyWith(
        maxAgeSeconds.map(value => MaxAgeSeconds.unwrap(value): Integer)
      )(_.maxAgeSeconds)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.CORSRule.ReadOnly =
    zio.aws.s3.model.CORSRule.wrap(buildAwsValue())
}
object CORSRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.CORSRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.CORSRule = zio.aws.s3.model.CORSRule(
      id.map(value => value),
      allowedHeaders.map(value => value),
      allowedMethods,
      allowedOrigins,
      exposeHeaders.map(value => value),
      maxAgeSeconds.map(value => value)
    )
    def id: Optional[ID]
    def allowedHeaders: Optional[List[AllowedHeader]]
    def allowedMethods: List[AllowedMethod]
    def allowedOrigins: List[AllowedOrigin]
    def exposeHeaders: Optional[List[ExposeHeader]]
    def maxAgeSeconds: Optional[MaxAgeSeconds]
    def getId: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", id)
    def getAllowedHeaders: ZIO[Any, AwsError, List[AllowedHeader]] =
      AwsError.unwrapOptionField("allowedHeaders", allowedHeaders)
    def getAllowedMethods: ZIO[Any, Nothing, List[AllowedMethod]] =
      ZIO.succeed(allowedMethods)
    def getAllowedOrigins: ZIO[Any, Nothing, List[AllowedOrigin]] =
      ZIO.succeed(allowedOrigins)
    def getExposeHeaders: ZIO[Any, AwsError, List[ExposeHeader]] =
      AwsError.unwrapOptionField("exposeHeaders", exposeHeaders)
    def getMaxAgeSeconds: ZIO[Any, AwsError, MaxAgeSeconds] =
      AwsError.unwrapOptionField("maxAgeSeconds", maxAgeSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CORSRule
  ) extends zio.aws.s3.model.CORSRule.ReadOnly {
    override val id: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.s3.model.primitives.ID(value))
    override val allowedHeaders: Optional[List[AllowedHeader]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowedHeaders())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.primitives.AllowedHeader(item)
          }.toList
        )
    override val allowedMethods: List[AllowedMethod] = impl
      .allowedMethods()
      .asScala
      .map { item =>
        zio.aws.s3.model.primitives.AllowedMethod(item)
      }
      .toList
    override val allowedOrigins: List[AllowedOrigin] = impl
      .allowedOrigins()
      .asScala
      .map { item =>
        zio.aws.s3.model.primitives.AllowedOrigin(item)
      }
      .toList
    override val exposeHeaders: Optional[List[ExposeHeader]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exposeHeaders())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.primitives.ExposeHeader(item)
          }.toList
        )
    override val maxAgeSeconds: Optional[MaxAgeSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.maxAgeSeconds())
      .map(value => zio.aws.s3.model.primitives.MaxAgeSeconds(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CORSRule
  ): zio.aws.s3.model.CORSRule.ReadOnly = new Wrapper(impl)
}
