package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait ChecksumAlgorithm {
  def unwrap: software.amazon.awssdk.services.s3.model.ChecksumAlgorithm
}
object ChecksumAlgorithm {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.ChecksumAlgorithm
  ): zio.aws.s3.model.ChecksumAlgorithm = value match {
    case software.amazon.awssdk.services.s3.model.ChecksumAlgorithm.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.ChecksumAlgorithm.CRC32 =>
      val r = CRC32
      r
    case software.amazon.awssdk.services.s3.model.ChecksumAlgorithm.CRC32_C =>
      val r = CRC32C
      r
    case software.amazon.awssdk.services.s3.model.ChecksumAlgorithm.SHA1 =>
      val r = SHA1
      r
    case software.amazon.awssdk.services.s3.model.ChecksumAlgorithm.SHA256 =>
      val r = SHA256
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.ChecksumAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ChecksumAlgorithm =
      software.amazon.awssdk.services.s3.model.ChecksumAlgorithm.UNKNOWN_TO_SDK_VERSION
  }
  case object CRC32 extends zio.aws.s3.model.ChecksumAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ChecksumAlgorithm =
      software.amazon.awssdk.services.s3.model.ChecksumAlgorithm.CRC32
  }
  case object CRC32C extends zio.aws.s3.model.ChecksumAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ChecksumAlgorithm =
      software.amazon.awssdk.services.s3.model.ChecksumAlgorithm.CRC32_C
  }
  case object SHA1 extends zio.aws.s3.model.ChecksumAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ChecksumAlgorithm =
      software.amazon.awssdk.services.s3.model.ChecksumAlgorithm.SHA1
  }
  case object SHA256 extends zio.aws.s3.model.ChecksumAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ChecksumAlgorithm =
      software.amazon.awssdk.services.s3.model.ChecksumAlgorithm.SHA256
  }
}
