package zio.aws.s3.model
import zio.aws.s3.model.primitives.Prefix
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CommonPrefix(prefix: Optional[Prefix] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.CommonPrefix = {
    import CommonPrefix.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CommonPrefix
      .builder()
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.CommonPrefix.ReadOnly =
    zio.aws.s3.model.CommonPrefix.wrap(buildAwsValue())
}
object CommonPrefix {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.CommonPrefix] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.CommonPrefix =
      zio.aws.s3.model.CommonPrefix(prefix.map(value => value))
    def prefix: Optional[Prefix]
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CommonPrefix
  ) extends zio.aws.s3.model.CommonPrefix.ReadOnly {
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CommonPrefix
  ): zio.aws.s3.model.CommonPrefix.ReadOnly = new Wrapper(impl)
}
